/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.external.jvnet.hk2.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import org.mvplugins.multiverse.external.glassfish.hk2.api.DescriptorVisibility;
import org.mvplugins.multiverse.external.glassfish.hk2.api.Injectee;
import org.mvplugins.multiverse.external.glassfish.hk2.api.InstantiationData;
import org.mvplugins.multiverse.external.glassfish.hk2.api.InstantiationService;
import org.mvplugins.multiverse.external.glassfish.hk2.api.Visibility;

@Visibility(value=DescriptorVisibility.LOCAL)
public class InstantiationServiceImpl
implements InstantiationService {
    private final ReentrantLock lock = new ReentrantLock();
    private final HashMap<Long, LinkedList<Injectee>> injecteeStack = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstantiationData getInstantiationData() {
        this.lock.lock();
        try {
            long tid = Thread.currentThread().getId();
            LinkedList<Injectee> threadStack = this.injecteeStack.get(tid);
            if (threadStack == null) {
                InstantiationData instantiationData = null;
                return instantiationData;
            }
            if (threadStack.isEmpty()) {
                InstantiationData instantiationData = null;
                return instantiationData;
            }
            final Injectee head = threadStack.getLast();
            InstantiationData instantiationData = new InstantiationData(){

                @Override
                public Injectee getParentInjectee() {
                    return head;
                }

                public String toString() {
                    return "InstantiationData(" + head + "," + System.identityHashCode(this) + ")";
                }
            };
            return instantiationData;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushInjecteeParent(Injectee injectee) {
        this.lock.lock();
        try {
            long tid = Thread.currentThread().getId();
            LinkedList<Injectee> threadStack = this.injecteeStack.get(tid);
            if (threadStack == null) {
                threadStack = new LinkedList();
                this.injecteeStack.put(tid, threadStack);
            }
            threadStack.addLast(injectee);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popInjecteeParent() {
        this.lock.lock();
        try {
            long tid = Thread.currentThread().getId();
            LinkedList<Injectee> threadStack = this.injecteeStack.get(tid);
            if (threadStack == null) {
                return;
            }
            threadStack.removeLast();
            if (threadStack.isEmpty()) {
                this.injecteeStack.remove(tid);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "InstantiationServiceImpl(" + this.injecteeStack.keySet() + "," + System.identityHashCode(this) + ")";
    }
}

