/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.external.commentedconfiguration.setting;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.external.commentedconfiguration.CommentedConfiguration;
import org.mvplugins.multiverse.external.commentedconfiguration.setting.CommentedNode;
import org.mvplugins.multiverse.external.commentedconfiguration.setting.TypedValueNode;
import org.mvplugins.multiverse.external.commentedconfiguration.setting.ValueNode;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public class Settings {
    private final CommentedConfiguration config;
    private final Path configPath;
    private final List<CommentedNode> defaultNodes;

    public Settings(@NotNull Path configPath, @NotNull Plugin plugin, @Nullable List<CommentedNode> defaultNodes) {
        if (configPath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.<init> must not be null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/github/townyadvanced/commentedconfiguration/setting/Settings.<init> must not be null");
        }
        if (configPath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.<init> must not be null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/github/townyadvanced/commentedconfiguration/setting/Settings.<init> must not be null");
        }
        this.config = new CommentedConfiguration(configPath, plugin);
        this.configPath = configPath;
        this.defaultNodes = defaultNodes;
    }

    public Settings(@NotNull Path configPath, @Nullable Logger logger, @Nullable List<CommentedNode> defaultNodes) {
        if (configPath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.<init> must not be null");
        }
        if (configPath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.<init> must not be null");
        }
        this.config = new CommentedConfiguration(configPath, logger);
        this.configPath = configPath;
        this.defaultNodes = defaultNodes;
    }

    public boolean load() {
        if (!this.createConfigFile()) {
            return false;
        }
        if (!this.config.load()) {
            return false;
        }
        this.addDefaultNodes();
        return true;
    }

    private boolean createConfigFile() {
        File configFile = this.configPath.toFile();
        if (configFile.exists()) {
            return true;
        }
        try {
            if (!configFile.createNewFile()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void addDefaultNodes() {
        if (this.defaultNodes == null || this.defaultNodes.isEmpty()) {
            return;
        }
        for (CommentedNode node : this.defaultNodes) {
            if (node.getComments().length > 0) {
                this.config.addComment(node.getPath(), node.getComments());
            }
            if (!(node instanceof ValueNode) || this.config.get(node.getPath()) != null) continue;
            this.config.set(node.getPath(), ((ValueNode)node).getDefaultValue());
        }
    }

    public void save() {
        this.config.save();
    }

    public Object get(@NotNull ValueNode node) {
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.get must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.get must not be null");
        }
        return this.config.get(node.getPath(), node.getDefaultValue());
    }

    public <T> T get(@NotNull ValueNode node, Class<T> type) {
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.get must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.get must not be null");
        }
        return (T)this.config.getObject(node.getPath(), type, node.getDefaultValue());
    }

    public <T> T get(@NotNull TypedValueNode<T> node) {
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.get must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.get must not be null");
        }
        return (T)this.config.getObject(node.getPath(), node.getType(), node.getDefaultValue());
    }

    public void set(@NotNull ValueNode node, Object value) {
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.set must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.set must not be null");
        }
        this.config.set(node.getPath(), value);
    }

    public <T> void set(@NotNull TypedValueNode<T> node, T value) {
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.set must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/github/townyadvanced/commentedconfiguration/setting/Settings.set must not be null");
        }
        this.config.set(node.getPath(), value);
    }

    @NotNull
    public CommentedConfiguration getConfig() {
        CommentedConfiguration commentedConfiguration = this.config;
        if (commentedConfiguration == null) {
            throw new IllegalStateException("NotNull method io/github/townyadvanced/commentedconfiguration/setting/Settings.getConfig must not return null");
        }
        if (commentedConfiguration == null) {
            throw new IllegalStateException("NotNull method io/github/townyadvanced/commentedconfiguration/setting/Settings.getConfig must not return null");
        }
        return commentedConfiguration;
    }
}

