/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.helpers;

import java.io.File;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Bukkit;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
public final class WorldNameChecker {
    private static final Set<String> BLACKLIST_NAMES = Set.of("cache", "config", "crash-reports", "libraries", "logs", "plugins", "versions");

    public boolean isValidWorldName(@Nullable String worldName) {
        return this.checkName(worldName) == NameStatus.VALID;
    }

    @NotNull
    public NameStatus checkName(@Nullable String worldName) {
        return Option.of(worldName).map(name -> name.toLowerCase(Locale.ENGLISH)).map(name -> {
            if (name.isEmpty()) {
                return NameStatus.EMPTY;
            }
            if (BLACKLIST_NAMES.contains(name)) {
                return NameStatus.BLACKLISTED;
            }
            if (!REPatterns.NAMESPACE_KEY.matcher((CharSequence)name).matches()) {
                return NameStatus.INVALID_CHARS;
            }
            return NameStatus.VALID;
        }).getOrElse(NameStatus.EMPTY);
    }

    public boolean hasWorldFolder(@Nullable String worldName) {
        return this.checkFolder(worldName) != FolderStatus.DOES_NOT_EXIST;
    }

    public boolean isValidWorldFolder(@Nullable String worldName) {
        return this.checkFolder(worldName) == FolderStatus.VALID;
    }

    public boolean isValidWorldFolder(@Nullable File worldFolder) {
        return this.checkFolder(worldFolder) == FolderStatus.VALID;
    }

    @NotNull
    public FolderStatus checkFolder(@Nullable String worldName) {
        if (worldName == null) {
            return FolderStatus.DOES_NOT_EXIST;
        }
        File worldFolder = new File(Bukkit.getWorldContainer(), worldName);
        return this.checkFolder(worldFolder);
    }

    @NotNull
    public FolderStatus checkFolder(@Nullable File worldFolder) {
        if (worldFolder == null || !worldFolder.exists() || !worldFolder.isDirectory()) {
            return FolderStatus.DOES_NOT_EXIST;
        }
        if (!this.folderHasDat(worldFolder)) {
            return FolderStatus.NOT_A_WORLD;
        }
        return FolderStatus.VALID;
    }

    private boolean folderHasDat(@NotNull File worldFolder) {
        File[] files = worldFolder.listFiles((file, name) -> name.toLowerCase(Locale.ENGLISH).endsWith(".dat"));
        return files != null && files.length > 0;
    }

    public static enum NameStatus {
        VALID,
        INVALID_CHARS,
        EMPTY,
        BLACKLISTED;

    }

    public static enum FolderStatus {
        VALID,
        NOT_A_WORLD,
        DOES_NOT_EXIST;

    }
}

