/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.ReflectHelper;
import org.mvplugins.multiverse.external.vavr.control.Try;

final class SpawnCategoryMapper {
    private static Map<SpawnCategory, List<EntityType>> spawnCategoryMap;

    SpawnCategoryMapper() {
    }

    private static void buildSpawnCategoryMap() {
        Field[] entityTypeFields;
        spawnCategoryMap = new HashMap<SpawnCategory, List<EntityType>>();
        Class<?> entityTypeClass = ReflectHelper.getClass("net.minecraft.world.entity.EntityType");
        if (entityTypeClass == null) {
            CoreLogging.warning("Failed to find EntityType class. SpawnCategoryMapper will not work.", new Object[0]);
            return;
        }
        Method getCategoryMethod = ReflectHelper.getMethod(entityTypeClass, "getCategory", new Class[0]);
        if (getCategoryMethod == null) {
            CoreLogging.warning("Failed to find getCategory method. SpawnCategoryMapper will not work.", new Object[0]);
            return;
        }
        Class<?> craftSpawnCategoryClass = ReflectHelper.getClass("org.bukkit.craftbukkit.util.CraftSpawnCategory");
        if (craftSpawnCategoryClass == null) {
            CoreLogging.warning("Failed to find CraftSpawnCategory class. SpawnCategoryMapper will not work.", new Object[0]);
            return;
        }
        Method toBukkitMethod = Arrays.stream(craftSpawnCategoryClass.getMethods()).filter(method -> method.getName().equals("toBukkit")).findFirst().orElse(null);
        if (toBukkitMethod == null) {
            CoreLogging.warning("Failed to find toBukkit method. SpawnCategoryMapper will not work.", new Object[0]);
            return;
        }
        for (Field entityTypeField : entityTypeFields = entityTypeClass.getFields()) {
            Object bukkitSpawnCategory;
            Object nmsEntityType;
            Object nsmMobCategory;
            String entityName = entityTypeField.getName();
            EntityType entityType = (EntityType)Try.of(() -> EntityType.valueOf((String)entityName)).getOrNull();
            if (entityType == null || (nsmMobCategory = ReflectHelper.invokeMethod(nmsEntityType = ReflectHelper.getFieldValue(null, entityTypeField, entityTypeClass), getCategoryMethod, new Object[0])) == null || !((bukkitSpawnCategory = ReflectHelper.invokeMethod(null, toBukkitMethod, nsmMobCategory)) instanceof SpawnCategory)) continue;
            SpawnCategory spawnCategory = (SpawnCategory)bukkitSpawnCategory;
            spawnCategoryMap.computeIfAbsent(spawnCategory, ignore -> new ArrayList()).add(entityType);
        }
    }

    static List<EntityType> getEntityTypes(SpawnCategory spawnCategory) {
        if (spawnCategoryMap == null) {
            return Collections.emptyList();
        }
        return spawnCategoryMap.get(spawnCategory);
    }

    static {
        SpawnCategoryMapper.buildSpawnCategoryMap();
    }
}

