/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.entity;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.config.handle.MemoryConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.config.node.ConfigNode;
import org.mvplugins.multiverse.core.config.node.ListConfigNode;
import org.mvplugins.multiverse.core.config.node.Node;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.core.config.node.serializer.NodeSerializer;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.entity.SpawnCategoryMapper;
import org.mvplugins.multiverse.external.vavr.control.Try;

public final class SpawnCategoryConfig {
    private final CoreConfig config;
    private final SpawnCategory spawnCategory;
    private final MemoryConfigurationHandle handle;
    private final StringPropertyHandle stringPropertyHandle;
    private final Nodes nodes;
    private MultiverseWorld world;

    SpawnCategoryConfig(CoreConfig config, SpawnCategory spawnCategory, ConfigurationSection section) {
        this.config = config;
        this.spawnCategory = spawnCategory;
        this.nodes = new Nodes();
        this.handle = MemoryConfigurationHandle.builder(section, this.nodes.nodes).build();
        this.stringPropertyHandle = new StringPropertyHandle(this.handle);
        this.handle.load();
    }

    ConfigurationSection saveSection() {
        this.handle.save().onFailure(throwable -> CoreLogging.warning("Failed to save SpawnCategoryConfig. " + throwable.getLocalizedMessage(), new Object[0]));
        return this.handle.getConfig();
    }

    void setWorldRef(MultiverseWorld world) {
        this.world = world;
    }

    void applyConfigToWorld() {
        if (this.spawnCategory == SpawnCategory.MISC) {
            return;
        }
        MultiverseWorld multiverseWorld = this.world;
        if (!(multiverseWorld instanceof LoadedMultiverseWorld)) {
            return;
        }
        LoadedMultiverseWorld loadedWorld = (LoadedMultiverseWorld)multiverseWorld;
        loadedWorld.getBukkitWorld().peek(bukkitWorld -> {
            this.applyTickPerSpawns((World)bukkitWorld);
            this.applySpawnLimit((World)bukkitWorld);
        });
    }

    private void applyTickPerSpawns(World bukkitWorld) {
        if (!this.config.getApplyEntitySpawnLimit()) {
            CoreLogging.finer("World %s %s skipping setTicksPerSpawns due to core config", this.world.getName(), this.spawnCategory);
            return;
        }
        if (!this.isSpawn() && this.getExceptions().isEmpty()) {
            CoreLogging.finer("World %s %s setTicksPerSpawns: 0", this.world.getName(), this.spawnCategory);
            bukkitWorld.setTicksPerSpawns(this.spawnCategory, 0);
            return;
        }
        if (this.getTickRate() == -2) {
            CoreLogging.finer("World %s %s skipping setTicksPerSpawns as tick-rate is UNSET", this.world.getName(), this.spawnCategory);
            return;
        }
        CoreLogging.finer("World %s %s setTicksPerSpawns: %d", this.world.getName(), this.spawnCategory, this.getTickRate());
        bukkitWorld.setTicksPerSpawns(this.spawnCategory, this.getTickRate());
    }

    private void applySpawnLimit(World bukkitWorld) {
        if (!this.config.getApplyEntitySpawnLimit()) {
            CoreLogging.finer("Skipping World %s %s setSpawnLimit due to core config", this.world.getName(), this.spawnCategory);
            return;
        }
        if (this.getSpawnLimit() == -2) {
            CoreLogging.finer("World %s %s skipping setSpawnLimit as spawn-limit is UNSET", this.world.getName(), this.spawnCategory);
            return;
        }
        CoreLogging.finer("World %s %s setSpawnLimit: %d", this.world.getName(), this.spawnCategory, this.getSpawnLimit());
        bukkitWorld.setSpawnLimit(this.spawnCategory, this.getSpawnLimit());
    }

    public StringPropertyHandle getStringPropertyHandle() {
        return this.stringPropertyHandle;
    }

    public SpawnCategory getSpawnCategory() {
        return this.spawnCategory;
    }

    public boolean isSpawn() {
        return this.handle.get(this.nodes.spawn);
    }

    public Try<Void> setSpawn(boolean spawn) {
        return this.handle.set(this.nodes.spawn, spawn);
    }

    public int getTickRate() {
        return this.handle.get(this.nodes.tickRate);
    }

    public Try<Void> setTickRate(int tickRate) {
        return this.handle.set(this.nodes.tickRate, tickRate);
    }

    public int getSpawnLimit() {
        return this.handle.get(this.nodes.spawnLimit);
    }

    public Try<Void> setSpawnLimit(int spawnLimit) {
        return this.handle.set(this.nodes.spawnLimit, spawnLimit);
    }

    public List<EntityType> getExceptions() {
        return (List)this.handle.get(this.nodes.exceptions);
    }

    public Try<Void> setExceptions(List<EntityType> exceptions) {
        return this.handle.set(this.nodes.exceptions, exceptions);
    }

    public boolean shouldAllowSpawn(Entity entity) {
        return this.shouldAllowSpawn(entity.getType());
    }

    public boolean shouldAllowSpawn(EntityType entityType) {
        return this.isSpawn() != this.getExceptions().contains(entityType);
    }

    public String toString() {
        return "SpawnCategoryConfig{spawnCategory=" + String.valueOf(this.spawnCategory) + ", spawn=" + this.isSpawn() + ", tickRate=" + this.getTickRate() + ", exceptions=" + String.valueOf(this.getExceptions()) + "}";
    }

    private final class Nodes {
        private final NodeGroup nodes = new NodeGroup();
        final ConfigNode<Boolean> spawn = (ConfigNode)this.node(((ConfigNode.Builder)ConfigNode.builder("spawn", Boolean.class).defaultValue(true).onLoadAndChange((oldValue, newValue) -> SpawnCategoryConfig.this.applyConfigToWorld())).build());
        final ConfigNode<Integer> tickRate = (ConfigNode)this.node(((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder("tick-rate", Integer.class).defaultValue(-2).suggester(input -> List.of("@unset", "@bukkit", "10", "100", "400", "1000"))).serializer(SpawnValueSerializer.INSTANCE)).onLoadAndChange((oldValue, newValue) -> SpawnCategoryConfig.this.applyConfigToWorld())).onChange((sender, oldValue, newValue) -> {
            if (!SpawnCategoryConfig.this.config.getApplyEntitySpawnRate()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Warning: Changing tick rates has no effect because 'apply-entity-spawn-rate' is disabled in the core config.");
            } else if (newValue == -2) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Note: Setting tick-rate to '@unset' may not reset to the server default until the world is reloaded or server is restarted.");
            }
        })).build());
        final ConfigNode<Integer> spawnLimit = (ConfigNode)this.node(((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder("spawn-limit", Integer.class).defaultValue(-2).suggester(input -> List.of("@unset", "@bukkit", "10", "100", "400", "1000"))).serializer(SpawnValueSerializer.INSTANCE)).onLoadAndChange((oldValue, newValue) -> SpawnCategoryConfig.this.applyConfigToWorld())).onChange((sender, oldValue, newValue) -> {
            if (!SpawnCategoryConfig.this.config.getApplyEntitySpawnLimit()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Warning: Changing spawn limits has no effect because 'apply-entity-spawn-limit' is disabled in the core config.");
            } else if (newValue == -2) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Note: Setting spawn-limit to '@unset' may not reset to the server default until the world is reloaded or server is restarted.");
            }
        })).build());
        final ListConfigNode<EntityType> exceptions = (ListConfigNode)this.node(((ListConfigNode.Builder)((ConfigNode.Builder)((ListConfigNode.Builder)ListConfigNode.listBuilder("exceptions", EntityType.class).defaultValue(ArrayList::new)).itemSuggester(input -> SpawnCategoryMapper.getEntityTypes(SpawnCategoryConfig.this.spawnCategory).stream().map(Enum::name).toList())).onLoadAndChange((oldValue, newValue) -> SpawnCategoryConfig.this.applyConfigToWorld())).build());

        private Nodes() {
        }

        private <N extends Node> N node(N node) {
            this.nodes.add(node);
            return node;
        }
    }

    private static class SpawnValueSerializer
    implements NodeSerializer<Integer> {
        private static final SpawnValueSerializer INSTANCE = new SpawnValueSerializer();

        private SpawnValueSerializer() {
        }

        @Override
        public Integer deserialize(Object object, Class<Integer> type) {
            String str = String.valueOf(object);
            if (str.equalsIgnoreCase("@unset")) {
                return -2;
            }
            if (str.equalsIgnoreCase("@bukkit")) {
                return -1;
            }
            return Integer.parseInt(str);
        }

        @Override
        public Object serialize(Integer object, Class<Integer> type) {
            return switch (object) {
                case -2 -> "@unset";
                case -1 -> "@bukkit";
                default -> object;
            };
        }
    }
}

