/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.config.handle.MemoryConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.config.migration.ConfigMigrator;
import org.mvplugins.multiverse.core.config.migration.VersionMigrator;
import org.mvplugins.multiverse.core.config.migration.action.BooleanMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.DeleteMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.DoubleMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.IntegerMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.LongMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.MigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.MoveMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.NullStringMigratorAction;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.AllowedPortalType;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldConfigNodes;
import org.mvplugins.multiverse.core.world.entity.EntitySpawnConfig;
import org.mvplugins.multiverse.core.world.location.SpawnLocation;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;

final class WorldConfig {
    private final String worldName;
    private final WorldConfigNodes configNodes;
    private final MemoryConfigurationHandle configHandle;
    private final StringPropertyHandle stringPropertyHandle;

    WorldConfig(@NotNull String worldName, @NotNull ConfigurationSection configSection, @NotNull MultiverseCore multiverseCore) {
        this.worldName = worldName;
        this.configNodes = new WorldConfigNodes(multiverseCore);
        this.configHandle = ((MemoryConfigurationHandle.Builder)((MemoryConfigurationHandle.Builder)MemoryConfigurationHandle.builder(configSection, this.configNodes.getNodes()).logger(CoreLogging.getLogger())).migrator(this.migrator())).build();
        this.stringPropertyHandle = new StringPropertyHandle(this.configHandle);
        this.load();
    }

    private ConfigMigrator migrator() {
        return ConfigMigrator.builder(this.configNodes.version).addVersionMigrator(VersionMigrator.builder(1.0).addAction(MoveMigratorAction.of("adjustSpawn", "adjust-spawn")).addAction(BooleanMigratorAction.of("adjust-spawn")).addAction(MoveMigratorAction.of("allowFlight", "allow-flight")).addAction(BooleanMigratorAction.of("allow-flight")).addAction(MoveMigratorAction.of("allowWeather", "allow-weather")).addAction(BooleanMigratorAction.of("allow-weather")).addAction(MoveMigratorAction.of("autoHeal", "auto-heal")).addAction(BooleanMigratorAction.of("auto-heal")).addAction(MoveMigratorAction.of("autoLoad", "auto-load")).addAction(BooleanMigratorAction.of("auto-load")).addAction(MoveMigratorAction.of("bedRespawn", "bed-respawn")).addAction(BooleanMigratorAction.of("bed-respawn")).addAction(MoveMigratorAction.of("entryfee.amount", "entry-fee.amount")).addAction(DoubleMigratorAction.of("entry-fee.amount")).addAction(MoveMigratorAction.of("entryfee.currency", "entry-fee.currency")).addAction(DeleteMigratorAction.of("entryfee")).addAction(MoveMigratorAction.of("gameMode", "gamemode")).addAction(NullStringMigratorAction.of("generator")).addAction(BooleanMigratorAction.of("hidden")).addAction(BooleanMigratorAction.of("hunger")).addAction(MoveMigratorAction.of("keepSpawnInMemory", "keep-spawn-in-memory")).addAction(BooleanMigratorAction.of("keep-spawn-in-memory")).addAction(MoveMigratorAction.of("playerLimit", "player-limit")).addAction(IntegerMigratorAction.of("player-limit")).addAction(MoveMigratorAction.of("portalForm", "portal-form")).addAction(BooleanMigratorAction.of("pvp")).addAction(MoveMigratorAction.of("respawnWorld", "respawn-world")).addAction(DoubleMigratorAction.of("scale")).addAction(LongMigratorAction.of("seed")).addAction(MoveMigratorAction.of("spawnLocation", "spawn-location")).addAction(BooleanMigratorAction.of("spawning.animals.spawn")).addAction(MoveMigratorAction.of("spawning.animals.spawnrate", "spawning.animals.tick-rate")).addAction(IntegerMigratorAction.of("spawning.animals.tick-rate")).addAction(BooleanMigratorAction.of("spawning.monsters.spawn")).addAction(MoveMigratorAction.of("spawning.monsters.spawnrate", "spawning.monsters.tick-rate")).addAction(IntegerMigratorAction.of("spawning.monsters.tick-rate")).addAction(MoveMigratorAction.of("worldBlacklist", "world-blacklist")).addAction(new EntryFeeMigrator()).addAction(new LegacyAliasMigrator()).build()).addVersionMigrator(VersionMigrator.builder(1.1).addAction(new BiomeMigrator()).build()).addVersionMigrator(VersionMigrator.builder(1.2).addAction(MoveMigratorAction.of("spawning.animals", "spawning.animal")).addAction(MoveMigratorAction.of("spawning.monsters", "spawning.monster")).build()).build();
    }

    Try<Void> load() {
        return this.configHandle.load();
    }

    Try<Void> load(ConfigurationSection section) {
        return this.configHandle.load(section);
    }

    Try<Void> save() {
        return this.configHandle.save().onFailure(ex -> CoreLogging.warning("Failed to save world config for world '%s'. %s", this.worldName, ex.getLocalizedMessage()));
    }

    ConfigurationSection getConfigurationSection() {
        return this.configHandle.getConfig();
    }

    StringPropertyHandle getStringPropertyHandle() {
        return this.stringPropertyHandle;
    }

    String getWorldName() {
        return this.worldName;
    }

    boolean getAdjustSpawn() {
        return this.configHandle.get(this.configNodes.adjustSpawn);
    }

    Try<Void> setAdjustSpawn(boolean adjustSpawn) {
        return this.configHandle.set(this.configNodes.adjustSpawn, adjustSpawn);
    }

    @Nullable
    String getAlias() {
        return this.configHandle.get(this.configNodes.alias);
    }

    Try<Void> setAlias(String alias) {
        return this.configHandle.set(this.configNodes.alias, alias);
    }

    boolean isAllowAdvancementGrant() {
        return this.configHandle.get(this.configNodes.allowAdvancementGrant);
    }

    Try<Void> setAllowAdvancementGrant(boolean allowAdvancementGrant) {
        return this.configHandle.set(this.configNodes.allowAdvancementGrant, allowAdvancementGrant);
    }

    boolean isAllowFlight() {
        return this.configHandle.get(this.configNodes.allowFlight);
    }

    Try<Void> setAllowFlight(boolean allowFlight) {
        return this.configHandle.set(this.configNodes.allowFlight, allowFlight);
    }

    boolean isAllowWeather() {
        return this.configHandle.get(this.configNodes.allowWeather);
    }

    Try<Void> setAllowWeather(boolean allowWeather) {
        return this.configHandle.set(this.configNodes.allowWeather, allowWeather);
    }

    boolean getAnchorRespawn() {
        return this.configHandle.get(this.configNodes.anchorRespawn);
    }

    Try<Void> setAnchorSpawn(boolean anchorSpawn) {
        return this.configHandle.set(this.configNodes.anchorRespawn, anchorSpawn);
    }

    boolean getAutoHeal() {
        return this.configHandle.get(this.configNodes.autoHeal);
    }

    Try<Void> setAutoHeal(boolean autoHeal) {
        return this.configHandle.set(this.configNodes.autoHeal, autoHeal);
    }

    boolean isAutoLoad() {
        return this.configHandle.get(this.configNodes.autoLoad);
    }

    Try<Void> setAutoLoad(boolean autoLoad) {
        return this.configHandle.set(this.configNodes.autoLoad, autoLoad);
    }

    String getBiome() {
        return this.configHandle.get(this.configNodes.biome);
    }

    Try<Void> setBiome(String biome) {
        return this.configHandle.set(this.configNodes.biome, biome);
    }

    boolean getBedRespawn() {
        return this.configHandle.get(this.configNodes.bedRespawn);
    }

    Try<Void> setBedRespawn(boolean bedRespawn) {
        return this.configHandle.set(this.configNodes.bedRespawn, bedRespawn);
    }

    Difficulty getDifficulty() {
        return this.configHandle.get(this.configNodes.difficulty);
    }

    Try<Void> setDifficulty(Difficulty difficulty) {
        return this.configHandle.set(this.configNodes.difficulty, difficulty);
    }

    boolean isEntryFeeEnabled() {
        return this.configHandle.get(this.configNodes.entryFeeEnabled);
    }

    Try<Void> setEntryFeeEnabled(boolean entryFeeEnabled) {
        return this.configHandle.set(this.configNodes.entryFeeEnabled, entryFeeEnabled);
    }

    double getEntryFeeAmount() {
        return this.configHandle.get(this.configNodes.entryFeeAmount);
    }

    Try<Void> setEntryFeeAmount(double entryFeeAmount) {
        return this.configHandle.set(this.configNodes.entryFeeAmount, entryFeeAmount);
    }

    Material getEntryFeeCurrency() {
        return this.configHandle.get(this.configNodes.entryFeeCurrency);
    }

    Try<Void> setEntryFeeCurrency(Material entryFeeCurrency) {
        return this.configHandle.set(this.configNodes.entryFeeCurrency, entryFeeCurrency);
    }

    World.Environment getEnvironment() {
        return this.configHandle.get(this.configNodes.environment);
    }

    Try<Void> setEnvironment(World.Environment environment) {
        return this.configHandle.set(this.configNodes.environment, environment);
    }

    GameMode getGameMode() {
        return this.configHandle.get(this.configNodes.gamemode);
    }

    Try<Void> setGameMode(GameMode gamemode) {
        return this.configHandle.set(this.configNodes.gamemode, gamemode);
    }

    String getGenerator() {
        return this.configHandle.get(this.configNodes.generator);
    }

    Try<Void> setGenerator(String generator) {
        return this.configHandle.set(this.configNodes.generator, generator);
    }

    boolean isHidden() {
        return this.configHandle.get(this.configNodes.hidden);
    }

    Try<Void> setHidden(boolean hidden) {
        return this.configHandle.set(this.configNodes.hidden, hidden);
    }

    boolean isHunger() {
        return this.configHandle.get(this.configNodes.hunger);
    }

    Try<Void> setHunger(boolean hunger) {
        return this.configHandle.set(this.configNodes.hunger, hunger);
    }

    boolean isKeepSpawnInMemory() {
        return this.configHandle.get(this.configNodes.keepSpawnInMemory);
    }

    Try<Void> setKeepSpawnInMemory(boolean keepSpawnInMemory) {
        return this.configHandle.set(this.configNodes.keepSpawnInMemory, keepSpawnInMemory);
    }

    int getPlayerLimit() {
        return this.configHandle.get(this.configNodes.playerLimit);
    }

    Try<Void> setPlayerLimit(int playerLimit) {
        return this.configHandle.set(this.configNodes.playerLimit, playerLimit);
    }

    AllowedPortalType getPortalForm() {
        return this.configHandle.get(this.configNodes.portalForm);
    }

    Try<Void> setPortalForm(AllowedPortalType portalForm) {
        return this.configHandle.set(this.configNodes.portalForm, portalForm);
    }

    boolean getPvp() {
        return this.configHandle.get(this.configNodes.pvp);
    }

    Try<Void> setPvp(boolean pvp) {
        return this.configHandle.set(this.configNodes.pvp, pvp);
    }

    String getRespawnWorld() {
        return this.configHandle.get(this.configNodes.respawnWorld);
    }

    Try<Void> setRespawnWorld(String respawnWorld) {
        return this.configHandle.set(this.configNodes.respawnWorld, respawnWorld);
    }

    double getScale() {
        return this.configHandle.get(this.configNodes.scale);
    }

    Try<Void> setScale(double scale) {
        return this.configHandle.set(this.configNodes.scale, scale);
    }

    long getSeed() {
        return this.configHandle.get(this.configNodes.seed);
    }

    Try<Void> setSeed(long seed) {
        return this.configHandle.set(this.configNodes.seed, seed);
    }

    SpawnLocation getSpawnLocation() {
        return this.configHandle.get(this.configNodes.spawnLocation);
    }

    Try<Void> setSpawnLocation(SpawnLocation spawnLocation) {
        return this.configHandle.set(this.configNodes.spawnLocation, spawnLocation);
    }

    EntitySpawnConfig getEntitySpawnConfig() {
        return this.configHandle.get(this.configNodes.enititySpawnConfig);
    }

    Try<Void> setEntitySpawnConfig(EntitySpawnConfig entitySpawnConfig) {
        return this.configHandle.set(this.configNodes.enititySpawnConfig, entitySpawnConfig);
    }

    List<String> getWorldBlacklist() {
        return this.configHandle.get(this.configNodes.worldBlacklist);
    }

    Try<Void> setWorldBlacklist(List<String> worldBlacklist) {
        return this.configHandle.set(this.configNodes.worldBlacklist, worldBlacklist);
    }

    void setMVWorld(@NotNull MultiverseWorld world) {
        this.configNodes.setWorld(world);
    }

    MultiverseWorld getMVWorld() {
        return this.configNodes.getWorld();
    }

    boolean isLoadedWorld() {
        return this.configNodes.getWorld() instanceof LoadedMultiverseWorld;
    }

    void deferenceMVWorld() {
        this.configNodes.setWorld(null);
    }

    static final class EntryFeeMigrator
    implements MigratorAction {
        EntryFeeMigrator() {
        }

        @Override
        public void migrate(ConfigurationSection config) {
            String currency = config.getString("entry-fee.currency", "");
            CoreLogging.info("Entry fee currency: %s", currency);
            if (currency.isEmpty()) {
                config.set("entry-fee.enabled", (Object)false);
                config.set("entry-fee.currency", (Object)"@vault-economy");
            } else {
                config.set("entry-fee.enabled", (Object)true);
            }
        }
    }

    private static final class LegacyAliasMigrator
    implements MigratorAction {
        private LegacyAliasMigrator() {
        }

        @Override
        public void migrate(ConfigurationSection config) {
            AtomicReference<String> alias = new AtomicReference<String>(config.getString("alias", ""));
            String color = config.getString("color", "");
            String style = config.getString("style", "");
            config.set("color", null);
            config.set("style", null);
            if (alias.get().isEmpty()) {
                return;
            }
            Try.of(() -> Enum.valueOf(EnglishChatColor.class, color.toUpperCase(Locale.ENGLISH))).map(c -> c.color).onSuccess(c -> {
                if (c != ChatColor.WHITE) {
                    alias.set("&" + c.getChar() + (String)alias.get());
                }
            });
            Try.of(() -> Enum.valueOf(EnglishChatStyle.class, style.toUpperCase(Locale.ENGLISH))).map(c -> c.color).onSuccess(s -> {
                if (s != null) {
                    alias.set("&" + s.getChar() + (String)alias.get());
                }
            });
            config.set("alias", (Object)alias.get());
        }

        private static enum EnglishChatStyle {
            NORMAL(null),
            MAGIC(ChatColor.MAGIC),
            BOLD(ChatColor.BOLD),
            STRIKETHROUGH(ChatColor.STRIKETHROUGH),
            UNDERLINE(ChatColor.UNDERLINE),
            ITALIC(ChatColor.ITALIC);

            private final ChatColor color;

            private EnglishChatStyle(ChatColor color) {
                this.color = color;
            }
        }

        private static enum EnglishChatColor {
            AQUA(ChatColor.AQUA),
            BLACK(ChatColor.BLACK),
            BLUE(ChatColor.BLUE),
            DARKAQUA(ChatColor.DARK_AQUA),
            DARKBLUE(ChatColor.DARK_BLUE),
            DARKGRAY(ChatColor.DARK_GRAY),
            DARKGREEN(ChatColor.DARK_GREEN),
            DARKPURPLE(ChatColor.DARK_PURPLE),
            DARKRED(ChatColor.DARK_RED),
            GOLD(ChatColor.GOLD),
            GRAY(ChatColor.GRAY),
            GREEN(ChatColor.GREEN),
            LIGHTPURPLE(ChatColor.LIGHT_PURPLE),
            RED(ChatColor.RED),
            YELLOW(ChatColor.YELLOW),
            WHITE(ChatColor.WHITE);

            private final ChatColor color;

            private EnglishChatColor(ChatColor color) {
                this.color = color;
            }
        }
    }

    private static final class BiomeMigrator
    implements MigratorAction {
        private BiomeMigrator() {
        }

        @Override
        public void migrate(ConfigurationSection config) {
            Object biome = config.getString("biome", "");
            if (((String)biome).equals("@vanilla")) {
                biome = "";
            } else if (!((String)biome).isEmpty()) {
                biome = "@single:" + (String)biome;
            }
            config.set("biome", biome);
        }
    }
}

