/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world;

import com.google.common.base.Strings;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.utils.text.ChatTextFormatter;
import org.mvplugins.multiverse.core.world.AllowedPortalType;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldConfig;
import org.mvplugins.multiverse.core.world.entity.EntitySpawnConfig;
import org.mvplugins.multiverse.core.world.location.SpawnLocation;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class MultiverseWorld {
    protected final String worldName;
    WorldConfig worldConfig;
    protected final CoreConfig config;
    private String colourlessAlias = "";

    MultiverseWorld(String worldName, WorldConfig worldConfig, CoreConfig config) {
        this.worldName = worldName;
        this.worldConfig = worldConfig;
        this.config = config;
        this.worldConfig.setMVWorld(this);
        this.updateColourlessAlias();
    }

    public String getName() {
        return this.worldName;
    }

    public String getTabCompleteName() {
        return this.config.getResolveAliasName() ? this.getColourlessAlias() : this.getName();
    }

    public boolean isLoaded() {
        return this.worldConfig.isLoadedWorld();
    }

    @ApiStatus.AvailableSince(value="5.5")
    public Option<LoadedMultiverseWorld> asLoadedWorld() {
        return Option.of(this.worldConfig.getMVWorld()).filter(world -> world instanceof LoadedMultiverseWorld).map(world -> (LoadedMultiverseWorld)world);
    }

    public StringPropertyHandle getStringPropertyHandle() {
        return this.worldConfig.getStringPropertyHandle();
    }

    public boolean getAdjustSpawn() {
        return this.worldConfig.getAdjustSpawn();
    }

    public Try<Void> setAdjustSpawn(boolean adjustSpawn) {
        return this.worldConfig.setAdjustSpawn(adjustSpawn);
    }

    public String getAlias() {
        return this.worldConfig.getAlias();
    }

    public Try<Void> setAlias(String alias) {
        return this.worldConfig.setAlias(alias);
    }

    public String getAliasOrName() {
        return Strings.isNullOrEmpty((String)this.worldConfig.getAlias()) ? this.worldName : this.worldConfig.getAlias();
    }

    public String getColourlessAlias() {
        return this.colourlessAlias;
    }

    void updateColourlessAlias() {
        this.colourlessAlias = ChatTextFormatter.removeColor(this.getAliasOrName());
    }

    public boolean isAllowAdvancementGrant() {
        return this.worldConfig.isAllowAdvancementGrant();
    }

    public Try<Void> setAllowAdvancementGrant(boolean allowAdvancementGrant) {
        return this.worldConfig.setAllowAdvancementGrant(allowAdvancementGrant);
    }

    public boolean isAllowFlight() {
        return this.worldConfig.isAllowFlight();
    }

    public Try<Void> setAllowFlight(boolean allowFlight) {
        return this.worldConfig.setAllowFlight(allowFlight);
    }

    public boolean isAllowWeather() {
        return this.worldConfig.isAllowWeather();
    }

    public Try<Void> setAllowWeather(boolean allowWeather) {
        return this.worldConfig.setAllowWeather(allowWeather);
    }

    public boolean getAnchorRespawn() {
        return this.worldConfig.getAnchorRespawn();
    }

    public Try<Void> setAnchorSpawn(boolean anchorSpawn) {
        return this.worldConfig.setAnchorSpawn(anchorSpawn);
    }

    public boolean getAutoHeal() {
        return this.worldConfig.getAutoHeal();
    }

    public Try<Void> setAutoHeal(boolean autoHeal) {
        return this.worldConfig.setAutoHeal(autoHeal);
    }

    public boolean isAutoLoad() {
        return this.worldConfig.isAutoLoad();
    }

    public Try<Void> setAutoLoad(boolean autoLoad) {
        return this.worldConfig.setAutoLoad(autoLoad);
    }

    public boolean getBedRespawn() {
        return this.worldConfig.getBedRespawn();
    }

    public Try<Void> setBedRespawn(boolean bedRespawn) {
        return this.worldConfig.setBedRespawn(bedRespawn);
    }

    @NotNull
    public String getBiome() {
        return this.worldConfig.getBiome();
    }

    public Material getCurrency() {
        return this.worldConfig.getEntryFeeCurrency();
    }

    public Try<Void> setCurrency(Material currency) {
        return this.worldConfig.setEntryFeeCurrency(currency);
    }

    public Difficulty getDifficulty() {
        return this.worldConfig.getDifficulty();
    }

    public Try<Void> setDifficulty(Difficulty difficulty) {
        return this.worldConfig.setDifficulty(difficulty);
    }

    public World.Environment getEnvironment() {
        return this.worldConfig.getEnvironment();
    }

    public GameMode getGameMode() {
        return this.worldConfig.getGameMode();
    }

    public Try<Void> setGameMode(GameMode gameMode) {
        return this.worldConfig.setGameMode(gameMode);
    }

    public String getGenerator() {
        return this.worldConfig.getGenerator();
    }

    public boolean isHidden() {
        return this.worldConfig.isHidden();
    }

    public Try<Void> setHidden(boolean hidden) {
        return this.worldConfig.setHidden(hidden);
    }

    public boolean isHunger() {
        return this.worldConfig.isHunger();
    }

    public Try<Void> setHunger(boolean hunger) {
        return this.worldConfig.setHunger(hunger);
    }

    public boolean isKeepSpawnInMemory() {
        return this.worldConfig.isKeepSpawnInMemory();
    }

    public Try<Void> setKeepSpawnInMemory(boolean keepSpawnInMemory) {
        return this.worldConfig.setKeepSpawnInMemory(keepSpawnInMemory);
    }

    public int getPlayerLimit() {
        return this.worldConfig.getPlayerLimit();
    }

    public Try<Void> setPlayerLimit(int playerLimit) {
        return this.worldConfig.setPlayerLimit(playerLimit);
    }

    public AllowedPortalType getPortalForm() {
        return this.worldConfig.getPortalForm();
    }

    public Try<Void> setPortalForm(AllowedPortalType portalForm) {
        return this.worldConfig.setPortalForm(portalForm);
    }

    public boolean isEntryFeeEnabled() {
        return this.worldConfig.isEntryFeeEnabled();
    }

    public Try<Void> setEntryFeeEnabled(boolean entryFeeEnabled) {
        return this.worldConfig.setEntryFeeEnabled(entryFeeEnabled);
    }

    public double getPrice() {
        return this.worldConfig.getEntryFeeAmount();
    }

    public Try<Void> setPrice(double price) {
        return this.worldConfig.setEntryFeeAmount(price);
    }

    public boolean getPvp() {
        return this.worldConfig.getPvp();
    }

    public Try<Void> setPvp(boolean pvp) {
        return this.worldConfig.setPvp(pvp);
    }

    public String getRespawnWorldName() {
        return this.worldConfig.getRespawnWorld();
    }

    @Nullable
    public World getRespawnWorld() {
        return Bukkit.getWorld((String)this.worldConfig.getRespawnWorld());
    }

    public Try<Void> setRespawnWorld(World respawnWorld) {
        return this.worldConfig.setRespawnWorld(respawnWorld.getName());
    }

    public Try<Void> setRespawnWorld(MultiverseWorld respawnWorld) {
        return this.worldConfig.setRespawnWorld(respawnWorld.getName());
    }

    public Try<Void> setRespawnWorld(String respawnWorld) {
        return this.worldConfig.setRespawnWorld(respawnWorld);
    }

    public double getScale() {
        return this.worldConfig.getScale();
    }

    public Try<Void> setScale(double scale) {
        return this.worldConfig.setScale(scale);
    }

    public long getSeed() {
        return this.worldConfig.getSeed();
    }

    public Location getSpawnLocation() {
        return this.worldConfig.getSpawnLocation().toBukkitLocation();
    }

    public Try<Void> setSpawnLocation(Location spawnLocation) {
        return this.worldConfig.setSpawnLocation(spawnLocation instanceof SpawnLocation ? (SpawnLocation)spawnLocation.clone() : new SpawnLocation(spawnLocation));
    }

    public EntitySpawnConfig getEntitySpawnConfig() {
        return this.worldConfig.getEntitySpawnConfig();
    }

    public Try<Void> setEntitySpawnConfig(EntitySpawnConfig entitySpawnConfig) {
        return this.worldConfig.setEntitySpawnConfig(entitySpawnConfig);
    }

    public List<String> getWorldBlacklist() {
        return this.worldConfig.getWorldBlacklist();
    }

    public Try<Void> setWorldBlacklist(List<String> worldBlacklist) {
        return this.worldConfig.setWorldBlacklist(worldBlacklist);
    }

    WorldConfig getWorldConfig() {
        return this.worldConfig;
    }

    void setWorldConfig(WorldConfig worldConfig) {
        this.worldConfig = worldConfig;
    }

    public String toString() {
        return "MultiverseWorld{name='" + this.worldName + "', env='" + String.valueOf(this.getEnvironment()) + "', gen='" + this.getGenerator() + "'}";
    }
}

