/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.webpaste;

import java.io.IOException;
import java.util.Map;
import org.mvplugins.multiverse.core.utils.webpaste.HttpAPIClient;
import org.mvplugins.multiverse.core.utils.webpaste.URLShortener;
import org.mvplugins.multiverse.external.minidev.json.JSONObject;
import org.mvplugins.multiverse.external.minidev.json.parser.JSONParser;
import org.mvplugins.multiverse.external.minidev.json.parser.ParseException;

final class BitlyURLShortener
extends URLShortener {
    private static final String ACCESS_TOKEN = "Bearer @bitly-access-token@";
    private static final String BITLY_POST_REQUEST = "https://api-ssl.bitly.com/v4/shorten";

    BitlyURLShortener() {
        super(BITLY_POST_REQUEST, ACCESS_TOKEN);
        if (ACCESS_TOKEN.endsWith("access-token")) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    String encodeData(String data) {
        JSONObject json = new JSONObject();
        json.put("long_url", data);
        return json.toJSONString();
    }

    @Override
    String encodeData(Map<String, String> data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String shorten(String longUrl) {
        try {
            String stringJSON = this.exec(this.encodeData(longUrl), HttpAPIClient.ContentType.JSON);
            return (String)((JSONObject)new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(stringJSON)).get("link");
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            return longUrl;
        }
    }
}

