/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.result;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mvplugins.multiverse.core.exceptions.MultiverseException;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.vavr.control.Either;
import org.mvplugins.multiverse.external.vavr.control.Try;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Attempt<T, F extends FailureReason> {
    public static <T, F extends FailureReason> Attempt<T, F> success(T value) {
        return new Success(value);
    }

    public static <T, F extends FailureReason> Attempt<T, F> failure(F failureReason, MessageReplacement ... messageReplacements) {
        return new Failure(failureReason, Message.of(failureReason, "Failed!", messageReplacements));
    }

    public static <T, F extends FailureReason> Attempt<T, F> failure(F failureReason, Message message) {
        return new Failure(failureReason, message);
    }

    public T get();

    public T getOrNull();

    public T getOrElse(T var1);

    public <X extends Throwable> T getOrThrow(Function<Failure<T, F>, X> var1) throws X;

    public F getFailureReason();

    public Message getFailureMessage();

    public boolean isSuccess();

    public boolean isFailure();

    @ApiStatus.AvailableSince(value="5.1")
    public Try<T> toTry();

    @ApiStatus.AvailableSince(value="5.1")
    public Try<T> toTry(Function<Failure<T, F>, Throwable> var1);

    default public Attempt<T, F> thenRun(Runnable runnable) {
        runnable.run();
        return this;
    }

    public Attempt<T, F> thenAccept(Consumer<Either<T, F>> var1);

    public Attempt<T, F> peek(Consumer<T> var1);

    public <U> Attempt<U, F> map(Function<? super T, ? extends U> var1);

    public <U> Attempt<U, F> map(Supplier<? extends U> var1);

    public <U> Attempt<U, F> mapAttempt(Function<? super T, Attempt<U, F>> var1);

    public <U> Attempt<U, F> mapAttempt(Supplier<Attempt<U, F>> var1);

    public <UF extends FailureReason> Attempt<T, UF> transform(UF var1);

    @ApiStatus.AvailableSince(value="5.1")
    public <U> U transform(Function<T, U> var1, Function<F, U> var2);

    public <N> N fold(Function<Failure<T, F>, N> var1, Function<T, N> var2);

    public Attempt<T, F> onSuccess(Runnable var1);

    public Attempt<T, F> onSuccess(Consumer<T> var1);

    public Attempt<T, F> onFailure(Runnable var1);

    public Attempt<T, F> onFailure(Consumer<Failure<T, F>> var1);

    public Attempt<T, F> onFailureReason(Consumer<F> var1);

    public static final class Success<T, F extends FailureReason>
    implements Attempt<T, F> {
        private final T value;

        Success(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T getOrNull() {
            return this.value;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return this.value;
        }

        @Override
        public <X extends Throwable> T getOrThrow(Function<Failure<T, F>, X> exceptionSupplier) throws X {
            return this.value;
        }

        @Override
        public F getFailureReason() {
            throw new UnsupportedOperationException("No failure reason as attempt is a success");
        }

        @Override
        public Message getFailureMessage() {
            throw new UnsupportedOperationException("No failure message as attempt is a success");
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public Try<T> toTry() {
            return Try.success(this.value);
        }

        @Override
        public Try<T> toTry(Function<Failure<T, F>, Throwable> throwableFunction) {
            return Try.success(this.value);
        }

        @Override
        public Attempt<T, F> thenAccept(Consumer<Either<T, F>> consumer) {
            consumer.accept(Either.left(this.value));
            return this;
        }

        @Override
        public Attempt<T, F> peek(Consumer<T> consumer) {
            consumer.accept(this.value);
            return this;
        }

        @Override
        public <U> Attempt<U, F> map(Function<? super T, ? extends U> mapper) {
            return new Success<U, F>(mapper.apply(this.value));
        }

        @Override
        public <U> Attempt<U, F> map(Supplier<? extends U> mapper) {
            return new Success<U, F>(mapper.get());
        }

        @Override
        public <U> Attempt<U, F> mapAttempt(Function<? super T, Attempt<U, F>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        public <U> Attempt<U, F> mapAttempt(Supplier<Attempt<U, F>> mapper) {
            return mapper.get();
        }

        @Override
        public <UF extends FailureReason> Attempt<T, UF> transform(UF failureReason) {
            return this.changeFailureType();
        }

        @Override
        public <U> U transform(Function<T, U> successMapper, Function<F, U> failureMapper) {
            return successMapper.apply(this.value);
        }

        @Override
        public <N> N fold(Function<Failure<T, F>, N> failureMapper, Function<T, N> successMapper) {
            return successMapper.apply(this.value);
        }

        @Override
        public Attempt<T, F> onSuccess(Runnable runnable) {
            runnable.run();
            return this;
        }

        @Override
        public Attempt<T, F> onSuccess(Consumer<T> consumer) {
            consumer.accept(this.value);
            return this;
        }

        @Override
        public Attempt<T, F> onFailure(Runnable runnable) {
            return this;
        }

        @Override
        public Attempt<T, F> onFailure(Consumer<Failure<T, F>> consumer) {
            return this;
        }

        @Override
        public Attempt<T, F> onFailureReason(Consumer<F> consumer) {
            return this;
        }

        private <UF extends FailureReason> Attempt<T, UF> changeFailureType() {
            Success mappedSuccess = this;
            return mappedSuccess;
        }

        public String toString() {
            return "Success{value=" + String.valueOf(this.value) + "}";
        }
    }

    public static final class Failure<T, F extends FailureReason>
    implements Attempt<T, F> {
        private final F failureReason;
        private final Message message;
        private final Failure<?, ?> causeBy;

        Failure(F failureReason, Message message) {
            this(failureReason, message, null);
        }

        Failure(Failure<?, F> failure) {
            this(failure.failureReason, failure.message, failure.causeBy);
        }

        Failure(F failureReason, Message message, Failure<?, ?> causeBy) {
            this.failureReason = failureReason;
            this.message = message;
            this.causeBy = causeBy;
        }

        @Override
        public T get() {
            throw new UnsupportedOperationException("No value as attempt is a failure");
        }

        @Override
        public T getOrNull() {
            return null;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return defaultValue;
        }

        @Override
        public <X extends Throwable> T getOrThrow(Function<Failure<T, F>, X> exceptionSupplier) throws X {
            throw (Throwable)exceptionSupplier.apply(this);
        }

        @Override
        public F getFailureReason() {
            return this.failureReason;
        }

        @Override
        public Message getFailureMessage() {
            return this.message;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public Try<T> toTry() {
            return Try.failure(new MultiverseException(this.message));
        }

        @Override
        public Try<T> toTry(Function<Failure<T, F>, Throwable> throwableFunction) {
            return Try.failure(throwableFunction.apply(this));
        }

        @Override
        public Attempt<T, F> thenAccept(Consumer<Either<T, F>> consumer) {
            consumer.accept(Either.right(this.failureReason));
            return this;
        }

        @Override
        public Attempt<T, F> peek(Consumer<T> consumer) {
            return this;
        }

        @Override
        public <U> Attempt<U, F> map(Function<? super T, ? extends U> mapper) {
            return this.changeValueType();
        }

        @Override
        public <U> Attempt<U, F> map(Supplier<? extends U> mapper) {
            return this.changeValueType();
        }

        @Override
        public <U> Attempt<U, F> mapAttempt(Function<? super T, Attempt<U, F>> mapper) {
            return this.changeValueType();
        }

        @Override
        public <U> Attempt<U, F> mapAttempt(Supplier<Attempt<U, F>> mapper) {
            return this.changeValueType();
        }

        @Override
        public <UF extends FailureReason> Attempt<T, UF> transform(UF failureReason) {
            return new Failure<T, UF>(failureReason, this.getFailureMessage(), this);
        }

        @Override
        public <U> U transform(Function<T, U> successMapper, Function<F, U> failureMapper) {
            return failureMapper.apply(this.failureReason);
        }

        @Override
        public <N> N fold(Function<Failure<T, F>, N> failureMapper, Function<T, N> successMapper) {
            return failureMapper.apply(this);
        }

        @Override
        public Attempt<T, F> onSuccess(Runnable runnable) {
            return this;
        }

        @Override
        public Attempt<T, F> onSuccess(Consumer<T> consumer) {
            return this;
        }

        @Override
        public Attempt<T, F> onFailure(Runnable runnable) {
            runnable.run();
            return this;
        }

        @Override
        public Attempt<T, F> onFailure(Consumer<Failure<T, F>> consumer) {
            consumer.accept(this);
            return this;
        }

        @Override
        public Attempt<T, F> onFailureReason(Consumer<F> consumer) {
            consumer.accept(this.failureReason);
            return this;
        }

        private <U> Attempt<U, F> changeValueType() {
            Failure mappedFailure = this;
            return mappedFailure;
        }

        public String toString() {
            return "Failure{reason=" + String.valueOf(this.failureReason) + (String)(this.causeBy != null ? ", causeBy=" + String.valueOf(this.causeBy) : "") + "}";
        }
    }
}

