/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.position;

import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.exceptions.utils.position.PositionParseException;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.position.PositionNumber;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="5.3")
public class VectorPosition {
    private final PositionNumber x;
    private final PositionNumber y;
    private final PositionNumber z;

    @ApiStatus.AvailableSince(value="5.3")
    public static VectorPosition ofAbsolute(double x, double y, double z) {
        return new VectorPosition(PositionNumber.ofAbsolute(x), PositionNumber.ofAbsolute(y), PositionNumber.ofAbsolute(z));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public static VectorPosition ofVector(Vector vector) {
        return new VectorPosition(PositionNumber.ofAbsolute(vector.getX()), PositionNumber.ofAbsolute(vector.getY()), PositionNumber.ofAbsolute(vector.getZ()));
    }

    public static VectorPosition ofLocation(Location location) {
        return new VectorPosition(PositionNumber.ofAbsolute(location.getX()), PositionNumber.ofAbsolute(location.getY()), PositionNumber.ofAbsolute(location.getZ()));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public static VectorPosition fromString(String coordStr) throws PositionParseException {
        String[] parts = REPatterns.COMMA.split(coordStr);
        if (parts.length != 3) {
            throw new PositionParseException(Message.of((MessageKeyProvider)MVCorei18n.EXCEPTION_POSITIONPARSE_INVALIDCOORDINATES, MessageReplacement.replace("{format}").with(coordStr)));
        }
        return new VectorPosition(PositionNumber.fromString(parts[0]), PositionNumber.fromString(parts[1]), PositionNumber.fromString(parts[2]));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public VectorPosition(PositionNumber x, PositionNumber y, PositionNumber z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public PositionNumber getX() {
        return this.x;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public PositionNumber getY() {
        return this.y;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public PositionNumber getZ() {
        return this.z;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public void augmentBukkitVector(Vector base) {
        base.setX(this.x.getValue(base.getX()));
        base.setY(this.y.getValue(base.getY()));
        base.setZ(this.z.getValue(base.getZ()));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public void augmentBukkitLocation(Location location) {
        location.setX(this.x.getValue(location.getX()));
        location.setY(this.y.getValue(location.getY()));
        location.setZ(this.z.getValue(location.getZ()));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public Vector toBukkitVector(Vector base) {
        return new Vector(this.x.getValue(base.getX()), this.y.getValue(base.getY()), this.z.getValue(base.getZ()));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public Location toBukkitLocation(Location base) {
        return new Location(base.getWorld(), this.x.getValue(base.getX()), this.y.getValue(base.getY()), this.z.getValue(base.getZ()), base.getYaw(), base.getPitch());
    }

    public String toString() {
        return String.valueOf(this.x) + "," + String.valueOf(this.y) + "," + String.valueOf(this.z);
    }
}

