/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public final class FileUtils {
    private final CoreConfig config;
    private final File serverFolder;
    private File bukkitYml;
    private File serverProperties;

    @Inject
    FileUtils(CoreConfig config) {
        this.config = config;
        this.serverFolder = new File(System.getProperty("user.dir"));
        CoreLogging.finer("Server folder: " + String.valueOf(this.serverFolder), new Object[0]);
    }

    public File getServerFolder() {
        return this.serverFolder;
    }

    @Nullable
    public File getBukkitConfig() {
        if (this.bukkitYml == null) {
            this.bukkitYml = this.findFileFromServerDirectory(this.config.getBukkitYmlPath());
            CoreLogging.finer("Bukkit.yml: " + String.valueOf(this.bukkitYml), new Object[0]);
        }
        return this.bukkitYml;
    }

    @Nullable
    public File getServerProperties() {
        if (this.serverProperties == null) {
            this.serverProperties = this.findFileFromServerDirectory(this.config.getServerPropertiesPath());
            CoreLogging.finer("server.properties: %s", this.serverProperties);
        }
        return this.serverProperties;
    }

    @Nullable
    private File findFileFromServerDirectory(String fileName) {
        if (this.serverFolder == null) {
            CoreLogging.warning("Unable to locate server directory.", new Object[0]);
            return null;
        }
        File file = new File(this.serverFolder, fileName);
        if (!file.exists()) {
            CoreLogging.warning("Unable to locate file from server directory: %s", fileName);
            return null;
        }
        return file;
    }

    public Try<Void> deleteFolder(File file) {
        return this.deleteFolder(file, Collections.emptyList());
    }

    public Try<Void> deleteFolder(File file, Collection<String> keepFiles) {
        return this.deleteFolder(file.toPath(), keepFiles);
    }

    public Try<Void> deleteFolder(Path path, Collection<String> keepFiles) {
        Try<Object> try_;
        block8: {
            Stream<Path> files = Files.walk(path, new FileVisitOption[0]);
            try {
                files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(file -> {
                    if (!this.isDirectoryEmpty((File)file)) {
                        CoreLogging.finest("Cannot delete folder as it is not empty: " + String.valueOf(file), new Object[0]);
                        return;
                    }
                    if (file.isFile() && keepFiles.contains(file.getName())) {
                        CoreLogging.finest("Keeping file: " + String.valueOf(file), new Object[0]);
                        return;
                    }
                    if (!file.delete()) {
                        throw new IllegalStateException("Failed to delete file: " + String.valueOf(file));
                    }
                });
                try_ = Try.success(null);
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CoreLogging.severe("Failed to delete folder: " + String.valueOf(path.toAbsolutePath()), new Object[0]);
                    e.printStackTrace();
                    return Try.failure(e);
                }
            }
            files.close();
        }
        return try_;
    }

    private boolean isDirectoryEmpty(File file) {
        boolean bl;
        block9: {
            if (!file.isDirectory()) {
                return true;
            }
            Stream<Path> entries = Files.list(file.toPath());
            try {
                bl = entries.findFirst().isEmpty();
                if (entries == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entries != null) {
                        try {
                            entries.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return true;
                }
            }
            entries.close();
        }
        return bl;
    }

    public Try<Void> copyFolder(File sourceDir, File targetDir) {
        return this.copyFolder(sourceDir.toPath(), targetDir.toPath(), Collections.emptyList());
    }

    public Try<Void> copyFolder(File sourceDir, File targetDir, List<String> excludeFiles) {
        return this.copyFolder(sourceDir.toPath(), targetDir.toPath(), excludeFiles);
    }

    public Try<Void> copyFolder(Path sourceDir, Path targetDir) {
        return this.copyFolder(sourceDir, targetDir, Collections.emptyList());
    }

    public Try<Void> copyFolder(Path sourceDir, Path targetDir, List<String> excludeFiles) {
        return Try.run(() -> Files.walkFileTree(sourceDir, new CopyDirFileVisitor(sourceDir, targetDir, excludeFiles))).onFailure(e -> {
            CoreLogging.severe("Failed to copy folder: " + String.valueOf(sourceDir.toAbsolutePath()), new Object[0]);
            e.printStackTrace();
        });
    }

    private static final class CopyDirFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path sourceDir;
        private final Path targetDir;
        private final List<String> excludeFiles;

        private CopyDirFileVisitor(@NotNull Path sourceDir, @NotNull Path targetDir, @NotNull List<String> excludeFiles) {
            this.sourceDir = sourceDir;
            this.targetDir = targetDir;
            this.excludeFiles = excludeFiles;
        }

        @Override
        @NotNull
        public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) throws IOException {
            Path newDir = this.targetDir.resolve(this.sourceDir.relativize(dir));
            if (!Files.isDirectory(newDir, new LinkOption[0])) {
                Files.createDirectory(newDir, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) throws IOException {
            if (this.excludeFiles.contains(file.getFileName().toString())) {
                CoreLogging.finest("Ignoring file: " + String.valueOf(file.getFileName()), new Object[0]);
                return FileVisitResult.CONTINUE;
            }
            Path targetFile = this.targetDir.resolve(this.sourceDir.relativize(file));
            Files.copy(file, targetFile, StandardCopyOption.COPY_ATTRIBUTES);
            return FileVisitResult.CONTINUE;
        }
    }
}

