/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.dynamiclistener;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.dynamiclistener.DynamicListener;
import org.mvplugins.multiverse.core.dynamiclistener.EventPriorityMapper;
import org.mvplugins.multiverse.core.dynamiclistener.EventRunnable;
import org.mvplugins.multiverse.core.dynamiclistener.EventRunnableExecutor;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.DefaultEventPriority;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventClass;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventPriorityKey;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.IgnoreIfCancelled;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.SkipIfEventExist;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.ReflectHelper;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public final class DynamicListenerRegistration {
    private static final boolean hasEventExecutorCreate = ReflectHelper.getMethod(EventExecutor.class, "create", new Class[]{Method.class, Class.class}) != null;
    private final EventPriorityMapper eventPriorityMapper;

    @Inject
    DynamicListenerRegistration(@NotNull EventPriorityMapper eventPriorityMapper) {
        this.eventPriorityMapper = eventPriorityMapper;
    }

    public void register(@NotNull DynamicListener listener, @NotNull Plugin plugin) {
        HashSet<Method> listenerMethods = new HashSet<Method>();
        listenerMethods.addAll(List.of(listener.getClass().getMethods()));
        listenerMethods.addAll(List.of(listener.getClass().getDeclaredMethods()));
        listenerMethods.forEach(method -> Try.run(() -> {
            if (method.isAnnotationPresent(EventMethod.class)) {
                this.registerAsEventMethod(listener, plugin, (Method)method);
            } else if (method.isAnnotationPresent(EventClass.class)) {
                this.registerAsEventClass(listener, plugin, (Method)method);
            }
        }).onFailure(e -> {
            CoreLogging.severe("Failed to register event method %s in %s", method.getName(), listener.getClass().getName());
            e.printStackTrace();
        }));
    }

    private void registerAsEventMethod(DynamicListener listener, Plugin plugin, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1 && !Event.class.isAssignableFrom(parameterTypes[0])) {
            CoreLogging.warning("Invalid event method %s in %s", method.getName(), listener.getClass().getName());
            return;
        }
        if (this.getSkipIfEventExist(method) != null) {
            return;
        }
        Class<Event> eventClass = parameterTypes[0].asSubclass(Event.class);
        method.setAccessible(true);
        EventExecutor eventExecutor = this.createEventExecutor(method, eventClass);
        EventPriority priority = this.getDynamicEventPriority(method);
        boolean ignoreCancelled = this.isIgnoreIfCancelled(method);
        CoreLogging.finest("Registering event listener for %s with priority %s", eventClass.getName(), priority);
        Bukkit.getPluginManager().registerEvent(eventClass, (Listener)listener, priority, eventExecutor, plugin, ignoreCancelled);
    }

    private void registerAsEventClass(DynamicListener listener, Plugin plugin, Method method) {
        Class<? extends Event> eventClass = this.getEventClass(method);
        if (eventClass == null) {
            return;
        }
        if (this.getSkipIfEventExist(method) != null) {
            CoreLogging.fine("Skipping event method %s in %s", method.getName(), listener.getClass().getName());
            return;
        }
        method.setAccessible(true);
        Object methodOutput = ReflectHelper.invokeMethod(listener, method, new Object[0]);
        if (!(methodOutput instanceof EventRunnable)) {
            CoreLogging.warning("Event method %s in %s did not return a SingleEventListener", method.getName(), listener.getClass().getName());
            return;
        }
        EventRunnable eventRunnable = (EventRunnable)methodOutput;
        EventRunnableExecutor<? extends Event> executor = new EventRunnableExecutor<Event>(eventClass, eventRunnable);
        EventPriority priority = this.getDynamicEventPriority(method);
        boolean ignoreCancelled = this.isIgnoreIfCancelled(method);
        CoreLogging.finest("Registering dynamic event for %s with priority %s", eventClass.getName(), priority);
        Bukkit.getPluginManager().registerEvent(eventClass, (Listener)listener, priority, executor, plugin, ignoreCancelled);
    }

    private Class<? extends Event> getEventClass(Method method) {
        EventClass eventClassAnnotation = method.getAnnotation(EventClass.class);
        if (eventClassAnnotation == null) {
            return null;
        }
        return this.getEventClassFromString(eventClassAnnotation.value());
    }

    private Class<? extends Event> getSkipIfEventExist(Method method) {
        SkipIfEventExist skipIfEventExist = method.getAnnotation(SkipIfEventExist.class);
        if (skipIfEventExist == null) {
            return null;
        }
        return this.getEventClassFromString(skipIfEventExist.value());
    }

    private Class<? extends Event> getEventClassFromString(String className) {
        Class<?> annotatedClass = ReflectHelper.getClass(className);
        if (annotatedClass == null || !Event.class.isAssignableFrom(annotatedClass)) {
            CoreLogging.fine("Event class does not exist: %s", className);
            return null;
        }
        return annotatedClass.asSubclass(Event.class);
    }

    private EventPriority getDynamicEventPriority(Method method) {
        return Option.of(method.getAnnotation(EventPriorityKey.class)).flatMap(eventPriorityKey -> this.eventPriorityMapper.getPriority(eventPriorityKey.value())).getOrElse(() -> this.getDefaultEventPriority(method));
    }

    private EventPriority getDefaultEventPriority(Method method) {
        DefaultEventPriority eventPriority = method.getAnnotation(DefaultEventPriority.class);
        return eventPriority == null ? EventPriority.NORMAL : eventPriority.value();
    }

    private boolean isIgnoreIfCancelled(Method method) {
        return method.isAnnotationPresent(IgnoreIfCancelled.class);
    }

    private EventExecutor createEventExecutor(Method method, Class<? extends Event> eventClass) {
        if (hasEventExecutorCreate) {
            return EventExecutor.create((Method)method, eventClass);
        }
        return (listener, event) -> {
            try {
                if (!eventClass.isAssignableFrom(event.getClass())) {
                    return;
                }
                method.invoke((Object)listener, event);
            }
            catch (InvocationTargetException ex) {
                throw new EventException(ex.getCause());
            }
            catch (Throwable t) {
                throw new EventException(t);
            }
        };
    }
}

