/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.display.filters;

import com.google.common.base.Strings;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mvplugins.multiverse.core.display.filters.ContentFilter;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.text.ChatTextFormatter;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public class RegexContentFilter
implements ContentFilter {
    private static final Pattern REGEX_SPECIAL_CHARS = Pattern.compile("[.+*?\\[^\\]$(){}=!<>|:-\\\\]");
    private final String regexString;
    private Pattern regexPattern;

    @NotNull
    public static RegexContentFilter fromString(@Nullable String filterString) {
        if (filterString == null) {
            return new RegexContentFilter(null);
        }
        if (filterString.startsWith("r=")) {
            return new RegexContentFilter(filterString.substring(2));
        }
        String cleanedFilter = REGEX_SPECIAL_CHARS.matcher(filterString.toLowerCase()).replaceAll("\\\\$0");
        return new RegexContentFilter(cleanedFilter);
    }

    RegexContentFilter(@Nullable String regexString) {
        this.regexString = regexString;
        this.convertToPattern();
    }

    private void convertToPattern() {
        if (Strings.isNullOrEmpty((String)this.regexString)) {
            return;
        }
        try {
            this.regexPattern = Pattern.compile(this.regexString);
        }
        catch (PatternSyntaxException ignored) {
            this.regexPattern = null;
            CoreLogging.fine("Error parsing regex: %s", this.regexString);
        }
    }

    @Override
    public boolean checkMatch(String value) {
        if (!this.hasValidRegex()) {
            return false;
        }
        String text = ChatTextFormatter.removeColor(String.valueOf(value));
        if (text == null) {
            return false;
        }
        try {
            return this.regexPattern.matcher(text.toLowerCase()).find();
        }
        catch (PatternSyntaxException ignored) {
            CoreLogging.warning("Error parsing regex '%s' for input '%s'", this.regexString, text);
            return false;
        }
    }

    @Override
    public boolean needToFilter() {
        return this.hasValidRegex();
    }

    public boolean hasValidRegex() {
        return this.regexPattern != null;
    }

    public String getRegexString() {
        return this.regexString;
    }

    public Pattern getRegexPattern() {
        return this.regexPattern;
    }

    @Override
    public String toString() {
        return this.regexString;
    }
}

