/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.destination.core.WorldDestinationInstance;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.entrycheck.WorldEntryCheckerProvider;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class WorldDestination
implements Destination<WorldDestination, WorldDestinationInstance, InstanceFailureReason> {
    private final CoreConfig config;
    private final WorldManager worldManager;
    private final LocationManipulation locationManipulation;
    private final WorldEntryCheckerProvider worldEntryCheckerProvider;

    @Inject
    WorldDestination(@NotNull CoreConfig config, @NotNull WorldManager worldManager, @NotNull LocationManipulation locationManipulation, @NotNull WorldEntryCheckerProvider worldEntryCheckerProvider) {
        this.config = config;
        this.worldManager = worldManager;
        this.locationManipulation = locationManipulation;
        this.worldEntryCheckerProvider = worldEntryCheckerProvider;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "w";
    }

    @Override
    @NotNull
    public Attempt<WorldDestinationInstance, InstanceFailureReason> getDestinationInstance(@NotNull CommandSender sender, @NotNull String destinationParams) {
        String[] items = REPatterns.COLON.split(destinationParams, 3);
        String worldName = items[0];
        MultiverseWorld world = this.getMultiverseWorld(worldName);
        if (world == null) {
            return Attempt.failure(InstanceFailureReason.WORLD_NOT_FOUND, MessageReplacement.Replace.WORLD.with(worldName));
        }
        String direction = items.length == 2 ? items[1] : null;
        float yaw = direction != null ? this.locationManipulation.getYaw(direction) : -1.0f;
        return Attempt.success(new WorldDestinationInstance(this, world, direction, yaw));
    }

    @Nullable
    private MultiverseWorld getMultiverseWorld(String worldName) {
        return this.config.getResolveAliasName() ? (MultiverseWorld)this.worldManager.getWorldByNameOrAlias(worldName).getOrNull() : (MultiverseWorld)this.worldManager.getWorld(worldName).getOrNull();
    }

    @Override
    @NotNull
    public Collection<DestinationSuggestionPacket> suggestDestinations(@NotNull CommandSender sender, @Nullable String destinationParams) {
        return this.worldManager.getLoadedWorlds().stream().filter(world -> this.worldEntryCheckerProvider.forSender(sender).canAccessWorld((MultiverseWorld)world).isSuccess()).map(world -> new DestinationSuggestionPacket(this, world.getTabCompleteName(), world.getName())).toList();
    }

    public static enum InstanceFailureReason implements FailureReason
    {
        WORLD_NOT_FOUND(MVCorei18n.DESTINATION_SHARED_FAILUREREASON_WORLDNOTFOUND);

        private final MessageKeyProvider messageKey;

        private InstanceFailureReason(MessageKeyProvider message) {
            this.messageKey = message;
        }

        @Override
        public MessageKey getMessageKey() {
            return this.messageKey.getMessageKey();
        }
    }
}

