/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.anchor.AnchorManager;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.destination.core.AnchorDestinationInstance;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class AnchorDestination
implements Destination<AnchorDestination, AnchorDestinationInstance, InstanceFailureReason> {
    private final AnchorManager anchorManager;

    @Inject
    AnchorDestination(AnchorManager anchorManager) {
        this.anchorManager = anchorManager;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "a";
    }

    @Override
    @NotNull
    public Attempt<AnchorDestinationInstance, InstanceFailureReason> getDestinationInstance(@NotNull CommandSender sender, @NotNull String destinationParams) {
        return this.anchorManager.getAnchor(destinationParams).fold(() -> Attempt.failure(InstanceFailureReason.ANCHOR_NOT_FOUND, MessageReplacement.replace("{anchor}").with(destinationParams)), anchor -> Attempt.success(new AnchorDestinationInstance(this, destinationParams, anchor.getLocation())));
    }

    @Override
    @NotNull
    public Collection<DestinationSuggestionPacket> suggestDestinations(@NotNull CommandSender sender, @Nullable String destinationParams) {
        return this.anchorManager.getAnchors(sender instanceof Player ? (Player)sender : null).stream().map(anchor -> new DestinationSuggestionPacket(this, anchor.getName(), anchor.getName())).toList();
    }

    public static enum InstanceFailureReason implements FailureReason
    {
        ANCHOR_NOT_FOUND(MVCorei18n.DESTINATION_ANCHOR_FAILUREREASON_ANCHORNOTFOUND);

        private final MessageKeyProvider messageKey;

        private InstanceFailureReason(MessageKeyProvider message) {
            this.messageKey = message;
        }

        @Override
        public MessageKey getMessageKey() {
            return this.messageKey.getMessageKey();
        }
    }
}

