/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.node.serializer;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mvplugins.multiverse.core.config.node.serializer.NodeSerializer;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public final class DefaultSerializerProvider {
    private static final Map<Class<?>, NodeSerializer<?>> SERIALIZERS = new HashMap();
    private static final NodeSerializer<Enum> ENUM_SERIALIZER = new NodeSerializer<Enum>(){

        @Override
        public Enum<?> deserialize(Object object, Class<Enum> type) {
            if (type.isInstance(object)) {
                return (Enum)object;
            }
            return Enum.valueOf(type, String.valueOf(object).toUpperCase(Locale.ENGLISH));
        }

        @Override
        public Object serialize(Enum object, Class<Enum> type) {
            return object.name().toLowerCase(Locale.ENGLISH);
        }
    };
    private static final NodeSerializer<String> STRING_SERIALIZER = new NodeSerializer<String>(){

        @Override
        public String deserialize(Object object, Class<String> type) {
            if (object instanceof String) {
                return (String)object;
            }
            return String.valueOf(object);
        }

        @Override
        public Object serialize(String object, Class<String> type) {
            return object;
        }
    };
    private static final NodeSerializer<Boolean> BOOLEAN_SERIALIZER = new NodeSerializer<Boolean>(){

        @Override
        public Boolean deserialize(Object object, Class<Boolean> type) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            String input = String.valueOf(object);
            return switch (input.toLowerCase(Locale.ENGLISH)) {
                case "t", "true", "on", "y", "yes", "1", "allow" -> true;
                case "f", "false", "off", "n", "no", "0", "deny" -> false;
                default -> throw new RuntimeException("Unable to convert '" + input + "' to boolean.");
            };
        }

        @Override
        public Object serialize(Boolean object, Class<Boolean> type) {
            return object;
        }
    };
    private static final NodeSerializer<Integer> INTEGER_SERIALIZER = new NodeSerializer<Integer>(){

        @Override
        public Integer deserialize(Object object, Class<Integer> type) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return Integer.parseInt(String.valueOf(object));
        }

        @Override
        public Object serialize(Integer object, Class<Integer> type) {
            return object;
        }
    };
    private static final NodeSerializer<Double> DOUBLE_SERIALIZER = new NodeSerializer<Double>(){

        @Override
        public Double deserialize(Object object, Class<Double> type) {
            if (object instanceof Double) {
                Double number = (Double)object;
                return number;
            }
            CoreLogging.finer("Converting %s to double", object);
            return Double.parseDouble(String.valueOf(object));
        }

        @Override
        public Object serialize(Double object, Class<Double> type) {
            return object;
        }
    };
    private static final NodeSerializer<Float> FLOAT_SERIALIZER = new NodeSerializer<Float>(){

        @Override
        public Float deserialize(Object object, Class<Float> type) {
            if (object instanceof Float) {
                Float number = (Float)object;
                return number;
            }
            CoreLogging.finer("Converting %s to float", object);
            return Float.valueOf(Float.parseFloat(String.valueOf(object)));
        }

        @Override
        public Object serialize(Float object, Class<Float> type) {
            return object;
        }
    };
    private static final NodeSerializer<Long> LONG_SERIALIZER = new NodeSerializer<Long>(){

        @Override
        public Long deserialize(Object object, Class<Long> type) {
            if (object instanceof Long) {
                Long number = (Long)object;
                return number;
            }
            CoreLogging.finer("Converting %s to long", object);
            return Long.parseLong(String.valueOf(object));
        }

        @Override
        public Object serialize(Long object, Class<Long> type) {
            return object;
        }
    };
    private static final NodeSerializer<Locale> LOCALE_SERIALIZER = new NodeSerializer<Locale>(){

        @Override
        public Locale deserialize(Object object, Class<Locale> type) {
            if (object instanceof Locale) {
                return (Locale)object;
            }
            String[] split = REPatterns.UNDERSCORE.split(String.valueOf(object), 2);
            return split.length > 1 ? new Locale(split[0], split[1]) : new Locale(split[0]);
        }

        @Override
        public Object serialize(Locale object, Class<Locale> type) {
            return object.toLanguageTag();
        }
    };

    public static <T> void addDefaultSerializer(@NotNull Class<T> type, @NotNull NodeSerializer<T> serializer) {
        SERIALIZERS.put(type, serializer);
    }

    @Nullable
    public static <T> NodeSerializer<T> getDefaultSerializer(Class<T> type) {
        if (type.isEnum()) {
            return ENUM_SERIALIZER;
        }
        return SERIALIZERS.get(type);
    }

    private DefaultSerializerProvider() {
    }

    static {
        DefaultSerializerProvider.addDefaultSerializer(String.class, STRING_SERIALIZER);
        DefaultSerializerProvider.addDefaultSerializer(Boolean.class, BOOLEAN_SERIALIZER);
        DefaultSerializerProvider.addDefaultSerializer(Integer.class, INTEGER_SERIALIZER);
        DefaultSerializerProvider.addDefaultSerializer(Double.class, DOUBLE_SERIALIZER);
        DefaultSerializerProvider.addDefaultSerializer(Float.class, FLOAT_SERIALIZER);
        DefaultSerializerProvider.addDefaultSerializer(Long.class, LONG_SERIALIZER);
        DefaultSerializerProvider.addDefaultSerializer(Locale.class, LOCALE_SERIALIZER);
    }
}

