/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.PageFilterFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.display.ContentDisplay;
import org.mvplugins.multiverse.core.display.filters.ContentFilter;
import org.mvplugins.multiverse.core.display.filters.DefaultContentFilter;
import org.mvplugins.multiverse.core.display.handlers.PagedSendHandler;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.display.parsers.MapContentProvider;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class WhoCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final PageFilterFlags flags;

    @Inject
    WhoCommand(@NotNull WorldManager worldManager, @NotNull PageFilterFlags flags) {
        this.worldManager = worldManager;
        this.flags = flags;
    }

    @Subcommand(value="whoall")
    @CommandPermission(value="multiverse.core.list.who.all")
    @CommandCompletion(value="@flags:groupName=pagefilter")
    @Syntax(value="[--page <page>] [--filter <filter>]")
    @Description(value="{@@mv-core.who.all.description}")
    void onWhoAllCommand(MVCommandIssuer issuer, @Optional @Syntax(value="[--page <page>] [--filter <filter>]") @Description(value="{@@mv-core.who.flags.description}") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        this.getListDisplay(this.worldManager.getLoadedWorlds(), (int)parsedFlags.flagValue(this.flags.page, 1), (ContentFilter)parsedFlags.flagValue(this.flags.filter, DefaultContentFilter.get()), true).send(issuer);
    }

    @Subcommand(value="who")
    @CommandPermission(value="multiverse.core.list.who")
    @CommandCompletion(value="@mvworlds:scope=both @flags:groupName=pagefilter")
    @Syntax(value="[world] [--page <page>] [--filter <filter>]")
    @Description(value="{@@mv-core.who.description}")
    void onWhoCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware,maxArgForAware=0") @Syntax(value="[world]") @Description(value="{@@mv-core.who.world.description}") LoadedMultiverseWorld inputtedWorld, @Optional @Syntax(value="[--page <page>] [--filter <filter>]") @Description(value="{@@mv-core.who.flags.description}") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        this.getListDisplay(inputtedWorld, (int)parsedFlags.flagValue(this.flags.page, 1), (ContentFilter)parsedFlags.flagValue(this.flags.filter, DefaultContentFilter.get()), false).send(issuer);
    }

    private Message phrasePlayerList(List<Player> players) {
        return Message.of(players.stream().map(Player::getName).collect(Collectors.joining(", ")), new MessageReplacement[0]);
    }

    private ContentDisplay getListDisplay(LoadedMultiverseWorld world, int page, ContentFilter filter, boolean ignoreEmptyWorlds) {
        ArrayList<LoadedMultiverseWorld> listingWorlds = new ArrayList<LoadedMultiverseWorld>();
        listingWorlds.add(world);
        return this.getListDisplay(listingWorlds, page, filter, ignoreEmptyWorlds);
    }

    private ContentDisplay getListDisplay(Collection<LoadedMultiverseWorld> worlds, int page, ContentFilter filter, boolean ignoreEmptyWorlds) {
        HashMap<String, Message> outMap = new HashMap<String, Message>();
        for (LoadedMultiverseWorld world : worlds) {
            @Nullable List players = (List)world.getPlayers().getOrNull();
            if (players != null && !players.isEmpty()) {
                outMap.put(world.getAliasOrName(), this.phrasePlayerList(players));
                continue;
            }
            if (ignoreEmptyWorlds) continue;
            outMap.put(world.getAliasOrName(), Message.of((MessageKeyProvider)MVCorei18n.WHO_EMPTY, new MessageReplacement[0]));
        }
        return ContentDisplay.create().addContent(MapContentProvider.forContent(outMap)).withSendHandler((SendHandler)((PagedSendHandler)PagedSendHandler.create().withHeader(Message.of((MessageKeyProvider)MVCorei18n.WHO_HEADER, new MessageReplacement[0]))).doPagination(true).withTargetPage(page).withFilter(filter));
    }

    @Service
    private static final class LegacyAlias
    extends WhoCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull WorldManager worldManager, @NotNull PageFilterFlags flags) {
            super(worldManager, flags);
        }

        @Override
        @CommandAlias(value="mvwhoall")
        void onWhoAllCommand(MVCommandIssuer issuer, String[] flags) {
            super.onWhoAllCommand(issuer, flags);
        }

        @Override
        @CommandAlias(value="mvwho|mvw")
        void onWhoCommand(MVCommandIssuer issuer, LoadedMultiverseWorld inputtedWorld, String[] flags) {
            super.onWhoCommand(issuer, inputtedWorld, flags);
        }
    }
}

