/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.mvplugins.multiverse.core.anchor.AnchorManager;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.event.MVConfigReloadEvent;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class ReloadCommand
extends CoreCommand {
    private final CoreConfig config;
    private final AnchorManager anchorManager;
    private final WorldManager worldManager;
    private final PluginManager pluginManager;

    @Inject
    ReloadCommand(@NotNull CoreConfig config, @NotNull AnchorManager anchorManager, @NotNull WorldManager worldManager, @NotNull PluginManager pluginManager) {
        this.config = config;
        this.anchorManager = anchorManager;
        this.worldManager = worldManager;
        this.pluginManager = pluginManager;
    }

    @Subcommand(value="reload")
    @CommandPermission(value="multiverse.core.reload")
    @Description(value="{@@mv-core.reload.description}")
    void onReloadCommand(@NotNull BukkitCommandIssuer issuer) {
        issuer.sendInfo(MVCorei18n.RELOAD_RELOADING, new String[0]);
        try {
            this.config.load().getOrElseThrow(e -> new RuntimeException("Failed to load config", (Throwable)e));
            this.worldManager.initAllWorlds().getOrElseThrow(e -> new RuntimeException("Failed to init worlds", (Throwable)e));
            this.anchorManager.loadAnchors().getOrElseThrow(e -> new RuntimeException("Failed to load anchors", (Throwable)e));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        ArrayList<String> configsLoaded = new ArrayList<String>();
        configsLoaded.add("Multiverse-Core - config.yml");
        configsLoaded.add("Multiverse-Core - worlds.yml");
        configsLoaded.add("Multiverse-Core - anchors.yml");
        MVConfigReloadEvent configReload = new MVConfigReloadEvent(configsLoaded);
        this.pluginManager.callEvent((Event)configReload);
        configReload.getAllConfigsLoaded().forEach(issuer::sendMessage);
        issuer.sendInfo(MVCorei18n.RELOAD_SUCCESS, new String[0]);
    }

    @Service
    private static final class LegacyAlias
    extends ReloadCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull CoreConfig config, @NotNull AnchorManager anchorManager, @NotNull WorldManager worldManager, @NotNull PluginManager pluginManager) {
            super(config, anchorManager, worldManager, pluginManager);
        }

        @Override
        @CommandAlias(value="mvreload|mvr")
        void onReloadCommand(@NotNull BukkitCommandIssuer issuer) {
            super.onReloadCommand(issuer);
        }
    }
}

