/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.context.GameRuleValue;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.PageFilterFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.display.ContentDisplay;
import org.mvplugins.multiverse.core.display.filters.DefaultContentFilter;
import org.mvplugins.multiverse.core.display.handlers.PagedSendHandler;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.display.parsers.MapContentProvider;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
class GameruleCommand
extends CoreCommand {
    private final PageFilterFlags flags;

    @Inject
    GameruleCommand(@NotNull PageFilterFlags flags) {
        this.flags = flags;
    }

    @Subcommand(value="gamerule|rule set")
    @CommandPermission(value="multiverse.core.gamerule.set")
    @CommandCompletion(value="@gamerules @gamerulesvalues @mvworlds:multiple|*")
    @Syntax(value="<Gamerule> <Gamerule value> [World or *]")
    @Description(value="{@@mv-core.gamerule.set.description}")
    void onGameruleSetCommand(MVCommandIssuer issuer, @Syntax(value="<Gamerule>") @Description(value="{@@mv-core.gamerule.set.gamerule.description}") GameRule gamerule, @Syntax(value="<Value>") @Description(value="{@@mv-core.gamerule.set.value.description}") GameRuleValue gameRuleValue, @Flags(value="resolve=issuerAware,maxArgForAware=2") @Syntax(value="[World or *]") @Description(value="{@@mv-core.gamerule.set.world.description}") LoadedMultiverseWorld[] worlds) {
        Object value = gameRuleValue.value();
        boolean success = true;
        for (LoadedMultiverseWorld world : worlds) {
            World bukkitWorld = (World)world.getBukkitWorld().getOrNull();
            if (bukkitWorld != null && bukkitWorld.setGameRule(gamerule, value)) continue;
            issuer.sendError((MessageKeyProvider)MVCorei18n.GAMERULE_SET_FAILED, MessageReplacement.Replace.GAMERULE.with(gamerule.getName()), MessageReplacement.Replace.VALUE.with(value.toString()), MessageReplacement.Replace.WORLD.with(world.getName()), MessageReplacement.replace("{type}").with(gamerule.getType().getName()));
            success = false;
        }
        if (success) {
            if (worlds.length == 1) {
                issuer.sendInfo((MessageKeyProvider)MVCorei18n.GAMERULE_SET_SUCCESS_SINGLE, MessageReplacement.Replace.GAMERULE.with(gamerule.getName()), MessageReplacement.Replace.VALUE.with(value.toString()), MessageReplacement.Replace.WORLD.with(worlds[0].getName()));
            } else if (worlds.length > 1) {
                issuer.sendInfo((MessageKeyProvider)MVCorei18n.GAMERULE_SET_SUCCESS_MULTIPLE, MessageReplacement.Replace.GAMERULE.with(gamerule.getName()), MessageReplacement.Replace.VALUE.with(value.toString()), MessageReplacement.Replace.COUNT.with(String.valueOf(worlds.length)));
            }
        }
    }

    @Subcommand(value="gamerule|rule reset")
    @CommandPermission(value="multiverse.core.gamerule.set")
    @CommandCompletion(value="@gamerules @mvworlds:multiple|*")
    @Syntax(value="<Gamerule> [World or *]")
    @Description(value="{@@mv-core.gamerule.reset.description}")
    void onGameruleResetCommand(MVCommandIssuer issuer, @Syntax(value="<Gamerule>") @Description(value="{@@mv-core.gamerule.reset.gamerule.description}") GameRule gamerule, @Flags(value="resolve=issuerAware,maxArgForAware=1") @Syntax(value="[World or *]") @Description(value="{@@mv-core.gamerule.reset.world.description}") LoadedMultiverseWorld[] worlds) {
        AtomicBoolean success = new AtomicBoolean(true);
        Arrays.stream(worlds).forEach(world -> world.getBukkitWorld().flatMap(bukkitWorld -> Option.of(bukkitWorld.getGameRuleDefault(gamerule)).map(value -> bukkitWorld.setGameRule(gamerule, value))).onEmpty(() -> {
            success.set(false);
            issuer.sendError((MessageKeyProvider)MVCorei18n.GAMERULE_RESET_FAILED, MessageReplacement.Replace.GAMERULE.with(gamerule.getName()), MessageReplacement.Replace.WORLD.with(world.getName()));
        }));
        if (success.get()) {
            if (worlds.length == 1) {
                issuer.sendInfo((MessageKeyProvider)MVCorei18n.GAMERULE_RESET_SUCCESS_SINGLE, MessageReplacement.Replace.GAMERULE.with(gamerule.getName()), MessageReplacement.Replace.WORLD.with(worlds[0].getName()));
            } else if (worlds.length > 1) {
                issuer.sendInfo((MessageKeyProvider)MVCorei18n.GAMERULE_RESET_SUCCESS_MULTIPLE, MessageReplacement.Replace.GAMERULE.with(gamerule.getName()), MessageReplacement.Replace.COUNT.with(String.valueOf(worlds.length)));
            }
        }
    }

    @Subcommand(value="gamerule|rule list")
    @CommandPermission(value="multiverse.core.gamerule.list")
    @CommandCompletion(value="@mvworlds|@flags:groupName=pagefilter @flags:groupName=pagefilter")
    @Syntax(value="[world] [--page <page>] [--filter <filter>]")
    @Description(value="{@@mv-core.gamerule.list.description}")
    void onGameruleListCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware,maxArgForAware=0") @Syntax(value="<world>") @Description(value="{@@mv-core.gamerule.list.description.world}") LoadedMultiverseWorld world, @Optional @Syntax(value="[--page <page>] [--filter <filter>]") @Description(value="{@@mv-core.gamerule.list.description.page}") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        ContentDisplay.create().addContent(MapContentProvider.forContent(this.getGameRuleMap((World)world.getBukkitWorld().getOrNull())).withKeyColor(ChatColor.AQUA).withValueColor(ChatColor.WHITE)).withSendHandler((SendHandler)((PagedSendHandler)PagedSendHandler.create().withHeader(this.getListTitle((World)world.getBukkitWorld().getOrNull()))).doPagination(true).withTargetPage(parsedFlags.flagValue(this.flags.page, 1)).withFilter(parsedFlags.flagValue(this.flags.filter, DefaultContentFilter.get()))).send(issuer);
    }

    private Map<String, String> getGameRuleMap(World world) {
        HashMap<String, String> gameRuleMap = new HashMap<String, String>();
        if (world == null) {
            return gameRuleMap;
        }
        for (String gamerule : world.getGameRules()) {
            GameRule gameruleEnum = GameRule.getByName((String)gamerule);
            if (gameruleEnum == null) continue;
            Object gameruleValue = world.getGameRuleValue(gameruleEnum);
            if (gameruleValue == null) {
                gameRuleMap.put(gameruleEnum.getName(), "null");
                continue;
            }
            gameRuleMap.put(gameruleEnum.getName(), gameruleValue.toString());
        }
        return gameRuleMap;
    }

    private Message getListTitle(@Nullable World world) {
        return Message.of((MessageKeyProvider)MVCorei18n.GAMERULE_LIST_TITLE, MessageReplacement.Replace.WORLD.with(world == null ? "null" : world.getName()));
    }

    @Service
    private static final class LegacyAlias
    extends GameruleCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull PageFilterFlags flags) {
            super(flags);
        }

        @Override
        @CommandAlias(value="mvrule|mvgamerule")
        void onGameruleSetCommand(MVCommandIssuer issuer, GameRule gamerule, GameRuleValue gameRuleValue, LoadedMultiverseWorld[] worlds) {
            super.onGameruleSetCommand(issuer, gamerule, gameRuleValue, worlds);
        }

        @Override
        void onGameruleResetCommand(MVCommandIssuer issuer, GameRule gamerule, LoadedMultiverseWorld[] worlds) {
            super.onGameruleResetCommand(issuer, gamerule, worlds);
        }

        @Override
        @CommandAlias(value="mvrules|mvgamerules")
        void onGameruleListCommand(MVCommandIssuer issuer, LoadedMultiverseWorld world, String[] flags) {
            super.onGameruleListCommand(issuer, world, flags);
        }
    }
}

