/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.commands.DumpsLogPoster;
import org.mvplugins.multiverse.core.event.MVDumpsDebugInfoEvent;
import org.mvplugins.multiverse.core.module.MultiverseModulesRegistry;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.FileUtils;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class DumpsService {
    private final MultiverseCore plugin;
    private final WorldManager worldManager;
    private final FileUtils fileUtils;

    @Inject
    DumpsService(@NotNull MultiverseCore plugin, @NotNull WorldManager worldManager, @NotNull FileUtils fileUtils) {
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.fileUtils = fileUtils;
    }

    void postLogs(MVCommandIssuer issuer, DumpsLogPoster.LogsType logsType, DumpsLogPoster.UploadType servicesType, boolean paranoid) {
        MVDumpsDebugInfoEvent versionEvent = this.createAndCallDebugInfoEvent();
        if (!paranoid) {
            versionEvent.putDetailedDebugInfo("plugins.md", "# Plugins\n\n" + this.getPluginList());
        }
        new DumpsLogPoster(issuer, logsType, servicesType, paranoid, this.getLogs(), versionEvent).runTaskAsynchronously((Plugin)this.plugin);
    }

    @NotNull
    private String getLogs() {
        Path logsPath = this.fileUtils.getServerFolder().toPath().resolve("logs/latest.log");
        File logsFile = logsPath.toFile();
        if (!logsFile.exists()) {
            CoreLogging.warning("Could not read logs/latest.log", new Object[0]);
            return "Could not find log";
        }
        return this.readLogsFromFile(logsPath);
    }

    @NotNull
    private String readLogsFromFile(Path logsPath) {
        String logs = "Could not read log";
        try {
            logs = Files.readString(logsPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            CoreLogging.severe("Could not read logs/latest.log. See below for stack trace", new Object[0]);
            e.printStackTrace();
            try {
                logs = Files.readString(logsPath, StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                CoreLogging.severe("Could not read ./logs/latest.log. See below for stack trace", new Object[0]);
                ex.printStackTrace();
            }
        }
        return logs;
    }

    private String getDebugInfoString() {
        return "# Multiverse-Core Version info\n\n - Multiverse-Core Version: " + this.plugin.getDescription().getVersion() + "\n - Bukkit Version: " + this.plugin.getServer().getVersion() + "\n - Loaded Worlds: " + String.valueOf(this.worldManager.getLoadedWorlds()) + "\n - Multiverse Plugins Loaded: " + StringFormatter.joinAnd(MultiverseModulesRegistry.get().getRegisteredPlugins()) + "\n - Multiverse Plugins Count: " + MultiverseModulesRegistry.get().getPluginCount() + "\n";
    }

    private MVDumpsDebugInfoEvent createAndCallDebugInfoEvent() {
        MVDumpsDebugInfoEvent event = new MVDumpsDebugInfoEvent();
        this.addDebugInfoToEvent(event);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    private void addDebugInfoToEvent(MVDumpsDebugInfoEvent event) {
        event.putDetailedDebugInfo("version.md", this.getDebugInfoString());
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        event.putDetailedDebugInfo("Multiverse-Core/config.yml", configFile);
        File worldsFile = new File(this.plugin.getDataFolder(), "worlds.yml");
        event.putDetailedDebugInfo("Multiverse-Core/worlds.yml", worldsFile);
        if (this.fileUtils.getBukkitConfig() != null) {
            event.putDetailedDebugInfo(this.fileUtils.getBukkitConfig().getPath(), this.fileUtils.getBukkitConfig());
        } else {
            CoreLogging.warning("/mv dumps could not find bukkit.yml. Not including file", new Object[0]);
        }
        if (this.fileUtils.getServerProperties() != null) {
            event.putDetailedDebugInfo(this.fileUtils.getServerProperties().getPath(), this.fileUtils.getServerProperties());
        } else {
            CoreLogging.warning("/mv dumps could not find server.properties. Not including file", new Object[0]);
        }
    }

    private String getPluginList() {
        return " - " + StringUtils.join(Arrays.stream(this.plugin.getServer().getPluginManager().getPlugins()).map(Object::toString).sorted().toList(), (String)"\n - ");
    }
}

