/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.external.vavr.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.mvplugins.multiverse.external.vavr.Tuple2;
import org.mvplugins.multiverse.external.vavr.collection.AbstractMultimap;
import org.mvplugins.multiverse.external.vavr.collection.Collections;
import org.mvplugins.multiverse.external.vavr.collection.HashMap;
import org.mvplugins.multiverse.external.vavr.collection.HashSet;
import org.mvplugins.multiverse.external.vavr.collection.List;
import org.mvplugins.multiverse.external.vavr.collection.Map;
import org.mvplugins.multiverse.external.vavr.collection.Multimap;
import org.mvplugins.multiverse.external.vavr.collection.Multimaps;
import org.mvplugins.multiverse.external.vavr.collection.Traversable;
import org.mvplugins.multiverse.external.vavr.collection.TreeSet;

public final class HashMultimap<K, V>
extends AbstractMultimap<K, V, HashMultimap<K, V>>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static <V> Builder<V> withSeq() {
        return new Builder(Multimap.ContainerType.SEQ, List::empty);
    }

    public static <V> Builder<V> withSet() {
        return new Builder(Multimap.ContainerType.SET, HashSet::empty);
    }

    public static <V extends Comparable<?>> Builder<V> withSortedSet() {
        return new Builder(Multimap.ContainerType.SORTED_SET, TreeSet::empty);
    }

    public static <V> Builder<V> withSortedSet(Comparator<? super V> comparator) {
        return new Builder(Multimap.ContainerType.SORTED_SET, () -> TreeSet.empty(comparator));
    }

    public static <K, V> HashMultimap<K, V> narrow(HashMultimap<? extends K, ? extends V> map) {
        return map;
    }

    private HashMultimap(Map<K, Traversable<V>> back, Multimap.ContainerType containerType, AbstractMultimap.SerializableSupplier<Traversable<?>> emptyContainer) {
        super(back, containerType, emptyContainer);
    }

    @Override
    protected <K2, V2> Map<K2, V2> emptyMapSupplier() {
        return HashMap.empty();
    }

    @Override
    protected <K2, V2> HashMultimap<K2, V2> emptyInstance() {
        return new HashMultimap(HashMap.empty(), this.getContainerType(), this.emptyContainer);
    }

    @Override
    protected <K2, V2> HashMultimap<K2, V2> createFromMap(Map<K2, Traversable<V2>> back) {
        return new HashMultimap<K2, V2>(back, this.getContainerType(), this.emptyContainer);
    }

    public static class Builder<V> {
        private final Multimap.ContainerType containerType;
        private final AbstractMultimap.SerializableSupplier<Traversable<?>> emptyContainer;

        private Builder(Multimap.ContainerType containerType, AbstractMultimap.SerializableSupplier<Traversable<?>> emptyContainer) {
            this.containerType = containerType;
            this.emptyContainer = emptyContainer;
        }

        public <K, V2 extends V> HashMultimap<K, V2> empty() {
            return new HashMultimap(HashMap.empty(), this.containerType, this.emptyContainer);
        }

        public <K, V2 extends V> HashMultimap<K, V2> ofEntries(Iterable<? extends Tuple2<? extends K, ? extends V2>> entries) {
            Objects.requireNonNull(entries, "entries is null");
            HashMultimap result = this.empty();
            for (Tuple2<K, V2> tuple2 : entries) {
                result = (HashMultimap)result.put(tuple2._1, tuple2._2);
            }
            return result;
        }

        @SafeVarargs
        public final <K, V2 extends V> HashMultimap<K, V2> ofEntries(Tuple2<? extends K, ? extends V2> ... entries) {
            Objects.requireNonNull(entries, "entries is null");
            HashMultimap result = this.empty();
            for (Tuple2<? extends K, ? extends V2> entry : entries) {
                result = (HashMultimap)result.put(entry._1, entry._2);
            }
            return result;
        }

        @SafeVarargs
        public final <K, V2 extends V> HashMultimap<K, V2> ofEntries(Map.Entry<? extends K, ? extends V2> ... entries) {
            Objects.requireNonNull(entries, "entries is null");
            HashMultimap result = this.empty();
            for (Map.Entry<K, V2> entry : entries) {
                result = (HashMultimap)result.put((Object)entry.getKey(), entry.getValue());
            }
            return result;
        }

        public <K, V2 extends V> HashMultimap<K, V2> ofAll(java.util.Map<? extends K, ? extends V2> map) {
            return Multimaps.ofJavaMap(this.empty(), map);
        }

        public <T, K, V2 extends V> HashMultimap<K, V2> ofAll(Stream<? extends T> stream, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V2> valueMapper) {
            return Multimaps.ofStream(this.empty(), stream, keyMapper, valueMapper);
        }

        public <T, K, V2 extends V> HashMultimap<K, V2> ofAll(Stream<? extends T> stream, Function<? super T, Tuple2<? extends K, ? extends V2>> entryMapper) {
            return Multimaps.ofStream(this.empty(), stream, entryMapper);
        }

        public <K, V2 extends V> HashMultimap<K, V2> tabulate(int n, Function<? super Integer, ? extends Tuple2<? extends K, ? extends V2>> f) {
            Objects.requireNonNull(f, "f is null");
            return this.ofEntries(Collections.tabulate(n, f));
        }

        public <K, V2 extends V> HashMultimap<K, V2> fill(int n, Supplier<? extends Tuple2<? extends K, ? extends V2>> s) {
            Objects.requireNonNull(s, "s is null");
            return this.ofEntries(Collections.fill(n, s));
        }

        public <K, V2 extends V> HashMultimap<K, V2> fill(int n, Tuple2<? extends K, ? extends V2> element) {
            return this.ofEntries(Collections.fillObject(n, element));
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K key, V2 value) {
            HashMultimap<K, V2> e = this.empty();
            return (HashMultimap)e.put((Object)key, (Object)value);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K k1, V2 v1, K k2, V2 v2) {
            return (HashMultimap)this.of(k1, v1).put((Object)k2, (Object)v2);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K k1, V2 v1, K k2, V2 v2, K k3, V2 v3) {
            return (HashMultimap)this.of(k1, v1, k2, v2).put((Object)k3, (Object)v3);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K k1, V2 v1, K k2, V2 v2, K k3, V2 v3, K k4, V2 v4) {
            return (HashMultimap)this.of(k1, v1, k2, v2, k3, v3).put((Object)k4, (Object)v4);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K k1, V2 v1, K k2, V2 v2, K k3, V2 v3, K k4, V2 v4, K k5, V2 v5) {
            return (HashMultimap)this.of(k1, v1, k2, v2, k3, v3, k4, v4).put((Object)k5, (Object)v5);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K k1, V2 v1, K k2, V2 v2, K k3, V2 v3, K k4, V2 v4, K k5, V2 v5, K k6, V2 v6) {
            return (HashMultimap)this.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5).put((Object)k6, (Object)v6);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K k1, V2 v1, K k2, V2 v2, K k3, V2 v3, K k4, V2 v4, K k5, V2 v5, K k6, V2 v6, K k7, V2 v7) {
            return (HashMultimap)this.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6).put((Object)k7, (Object)v7);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K k1, V2 v1, K k2, V2 v2, K k3, V2 v3, K k4, V2 v4, K k5, V2 v5, K k6, V2 v6, K k7, V2 v7, K k8, V2 v8) {
            return (HashMultimap)this.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7).put((Object)k8, (Object)v8);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K k1, V2 v1, K k2, V2 v2, K k3, V2 v3, K k4, V2 v4, K k5, V2 v5, K k6, V2 v6, K k7, V2 v7, K k8, V2 v8, K k9, V2 v9) {
            return (HashMultimap)this.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8).put((Object)k9, (Object)v9);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(K k1, V2 v1, K k2, V2 v2, K k3, V2 v3, K k4, V2 v4, K k5, V2 v5, K k6, V2 v6, K k7, V2 v7, K k8, V2 v8, K k9, V2 v9, K k10, V2 v10) {
            return (HashMultimap)this.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9).put((Object)k10, (Object)v10);
        }

        public <K, V2 extends V> HashMultimap<K, V2> of(Tuple2<? extends K, ? extends V2> entry) {
            HashMultimap<K, V2> e = this.empty();
            return (HashMultimap)e.put(entry._1, entry._2);
        }

        public <K, V2 extends V> Collector<Tuple2<K, V2>, ArrayList<Tuple2<K, V2>>, Multimap<K, V2>> collector() {
            Supplier<ArrayList> supplier = ArrayList::new;
            BiConsumer<ArrayList, Tuple2> accumulator = ArrayList::add;
            BinaryOperator combiner = (left, right) -> {
                left.addAll(right);
                return left;
            };
            return Collector.of(supplier, accumulator, combiner, this::ofEntries, new Collector.Characteristics[0]);
        }
    }
}

