/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.biomeprovider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.BiomeProvider;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.world.biomeprovider.BiomeProviderParser;
import org.mvplugins.multiverse.core.world.biomeprovider.SingleBiomeProviderParser;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class BiomeProviderFactory {
    private final Map<String, BiomeProviderParser> biomeProviderParsers = new HashMap<String, BiomeProviderParser>();

    @Inject
    BiomeProviderFactory() {
        this.registerBiomeProviderParser("single", new SingleBiomeProviderParser());
    }

    public void registerBiomeProviderParser(@NotNull String key, @NotNull BiomeProviderParser biomeProviderParser) {
        this.biomeProviderParsers.put("@" + key, biomeProviderParser);
    }

    public BiomeProvider parseBiomeProvider(@NotNull String worldName, @NotNull String biomeProviderString) {
        String[] split;
        BiomeProviderParser biomeProviderParser;
        if (biomeProviderString.isEmpty()) {
            return null;
        }
        if (biomeProviderString.startsWith("@") && (biomeProviderParser = this.biomeProviderParsers.get((split = REPatterns.COLON.split(biomeProviderString, 2))[0])) != null) {
            return biomeProviderParser.parseBiomeProvider(worldName, split.length > 1 ? split[1] : "");
        }
        return WorldCreator.getBiomeProviderForName((String)worldName, (String)biomeProviderString, (CommandSender)Bukkit.getConsoleSender());
    }

    public Collection<String> suggestBiomeString(@NotNull String currentInput) {
        String[] split = REPatterns.COLON.split(currentInput, 2);
        if (split.length < 2) {
            return this.biomeProviderParsers.keySet().stream().map(key -> currentInput.equals(key) ? key + ":" : key).toList();
        }
        BiomeProviderParser biomeProviderParser = this.biomeProviderParsers.get(split[0]);
        if (biomeProviderParser != null) {
            return biomeProviderParser.suggestParams(split[1]).stream().map(key -> split[0] + ":" + key).toList();
        }
        return Collections.emptyList();
    }
}

