/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

public class REPatterns {
    private static final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();
    public static final Pattern COLON = REPatterns.get(":");
    public static final Pattern COMMA = REPatterns.get(",");
    public static final Pattern DOT = REPatterns.get("\\.");
    public static final Pattern EQUALS = REPatterns.get("=");
    @ApiStatus.AvailableSince(value="5.4")
    public static final Pattern HYPHEN = REPatterns.get("-");
    @ApiStatus.AvailableSince(value="5.4")
    public static final Pattern NAMESPACE = REPatterns.get("^[a-z0-9_.-]+$");
    @ApiStatus.AvailableSince(value="5.4")
    public static final Pattern NAMESPACE_KEY = REPatterns.get("^[a-z0-9/_.-]+$");
    public static final Pattern SEMICOLON = REPatterns.get(";");
    @ApiStatus.AvailableSince(value="5.4")
    public static final Pattern SPACE = REPatterns.get(" ");
    public static final Pattern UNDERSCORE = REPatterns.get("_");
    public static final Pattern UUID = REPatterns.get("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");
    @ApiStatus.AvailableSince(value="5.4")
    public static final Pattern YAML_KEY = REPatterns.get("^[a-zA-Z0-9\\[\\]_-]+$");

    public static Pattern get(String regex) {
        return patternCache.computeIfAbsent(regex, Pattern::compile);
    }
}

