/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.locale.message;

import java.util.Objects;
import org.mvplugins.multiverse.core.locale.message.LocalizedMessage;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.ACFUtil;
import org.mvplugins.multiverse.external.acf.commands.CommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.Locales;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.Contract;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class Message {
    @NotNull
    private final String message;
    @NotNull
    protected final MessageReplacement[] replacements;

    @Contract(value="_, _ -> new", pure=true)
    public static Message of(@NotNull String message, MessageReplacement ... replacements) {
        Objects.requireNonNull(message, "message must not be null");
        for (MessageReplacement replacement : replacements) {
            Objects.requireNonNull(replacement, "replacements must not contain null");
        }
        return new Message(message, replacements);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static LocalizedMessage of(@NotNull MessageKeyProvider messageKeyProvider, MessageReplacement ... replacements) {
        return Message.of(messageKeyProvider, "{error_key: %s}".formatted(messageKeyProvider.getMessageKey().getKey()), replacements);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static LocalizedMessage of(@NotNull MessageKeyProvider messageKeyProvider, @NotNull String nonLocalizedMessage, MessageReplacement ... replacements) {
        Objects.requireNonNull(messageKeyProvider, "messageKeyProvider must not be null");
        Objects.requireNonNull(nonLocalizedMessage, "message must not be null");
        for (MessageReplacement replacement : replacements) {
            Objects.requireNonNull(replacement, "replacements must not contain null");
        }
        return new LocalizedMessage(messageKeyProvider, nonLocalizedMessage, replacements);
    }

    protected Message(@NotNull String message, MessageReplacement ... replacements) {
        this.message = message;
        this.replacements = replacements;
    }

    @NotNull
    public String[] getReplacements() {
        return Message.toReplacementsArray(this.replacements);
    }

    @NotNull
    public String[] getReplacements(@NotNull Locales locales, @Nullable CommandIssuer commandIssuer) {
        return Message.toReplacementsArray(locales, commandIssuer, this.replacements);
    }

    @NotNull
    public String raw() {
        return this.message;
    }

    @NotNull
    public String formatted() {
        String[] parsedReplacements = this.getReplacements();
        if (parsedReplacements.length == 0) {
            return this.raw();
        }
        return ACFUtil.replaceStrings(this.message, parsedReplacements);
    }

    @NotNull
    public String formatted(@NotNull Locales locales) {
        return this.formatted(locales, null);
    }

    @NotNull
    public String formatted(@NotNull CommandIssuer commandIssuer) {
        return this.formatted(commandIssuer.getManager().getLocales(), commandIssuer);
    }

    @NotNull
    public String formatted(@NotNull Locales locales, @Nullable CommandIssuer commandIssuer) {
        String[] parsedReplacements = this.getReplacements(locales, commandIssuer);
        if (parsedReplacements.length == 0) {
            return this.raw();
        }
        return ACFUtil.replaceStrings(this.message, parsedReplacements);
    }

    private static String[] toReplacementsArray(MessageReplacement ... replacements) {
        String[] replacementsArray = new String[replacements.length * 2];
        int i = 0;
        for (MessageReplacement replacement : replacements) {
            replacementsArray[i++] = replacement.getKey();
            replacementsArray[i++] = replacement.getReplacement().fold(s -> s, Message::formatted);
        }
        return replacementsArray;
    }

    private static String[] toReplacementsArray(@NotNull Locales locales, @Nullable CommandIssuer commandIssuer, MessageReplacement ... replacements) {
        String[] replacementsArray = new String[replacements.length * 2];
        int i = 0;
        for (MessageReplacement replacement : replacements) {
            replacementsArray[i++] = replacement.getKey();
            replacementsArray[i++] = replacement.getReplacement().fold(str -> str, message -> message.formatted(locales, commandIssuer));
        }
        return replacementsArray;
    }
}

