/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.listeners;

import com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent;
import org.mvplugins.multiverse.core.dynamiclistener.EventRunnable;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventClass;
import org.mvplugins.multiverse.core.listeners.CoreListener;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class MVAdvancementListener
implements CoreListener {
    private final WorldManager worldManager;

    @Inject
    MVAdvancementListener(@NotNull WorldManager worldManager) {
        this.worldManager = worldManager;
    }

    @EventClass(value="com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent")
    EventRunnable playerAdvancementCriterionGrant() {
        return new EventRunnable<PlayerAdvancementCriterionGrantEvent>(){

            @Override
            public void onEvent(PlayerAdvancementCriterionGrantEvent event) {
                MVAdvancementListener.this.worldManager.getLoadedWorld(event.getPlayer().getWorld()).peek(mvWorld -> {
                    if (!mvWorld.isAllowAdvancementGrant() && !event.getCriterion().equals("unlock_right_away")) {
                        CoreLogging.finest("Advancement criterion cancelled: %s", event.getCriterion());
                        event.setCancelled(true);
                    }
                });
            }
        };
    }
}

