/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import java.util.Collection;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.destination.core.CannonDestinationInstance;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.location.UnloadedWorldLocation;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
public final class CannonDestination
implements Destination<CannonDestination, CannonDestinationInstance, InstanceFailureReason> {
    private final WorldManager worldManager;

    @Inject
    CannonDestination(WorldManager worldManager) {
        this.worldManager = worldManager;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "ca";
    }

    @Override
    @NotNull
    public Attempt<CannonDestinationInstance, InstanceFailureReason> getDestinationInstance(@NotNull CommandSender sender, @NotNull String destinationParams) {
        double dSpeed;
        UnloadedWorldLocation location;
        String[] params = REPatterns.COLON.split(destinationParams);
        if (params.length != 5) {
            return Attempt.failure(InstanceFailureReason.INVALID_FORMAT, new MessageReplacement[0]);
        }
        String worldName = params[0];
        String coordinates = params[1];
        String pitch = params[2];
        String yaw = params[3];
        String speed = params[4];
        String[] coordinatesParams = REPatterns.COMMA.split(coordinates);
        if (coordinatesParams.length != 3) {
            return Attempt.failure(InstanceFailureReason.INVALID_COORDINATES_FORMAT, new MessageReplacement[0]);
        }
        World world = (World)((Option)this.worldManager.getLoadedWorld(worldName).map(LoadedMultiverseWorld::getBukkitWorld).getOrNull()).getOrNull();
        if (world == null) {
            return Attempt.failure(InstanceFailureReason.WORLD_NOT_FOUND, MessageReplacement.Replace.WORLD.with(worldName));
        }
        try {
            location = new UnloadedWorldLocation(world, Double.parseDouble(coordinatesParams[0]), Double.parseDouble(coordinatesParams[1]), Double.parseDouble(coordinatesParams[2]), Float.parseFloat(yaw), Float.parseFloat(pitch));
            dSpeed = Double.parseDouble(speed);
        }
        catch (NumberFormatException e) {
            return Attempt.failure(InstanceFailureReason.INVALID_NUMBER_FORMAT, MessageReplacement.Replace.ERROR.with(e));
        }
        return Attempt.success(new CannonDestinationInstance(this, location, dSpeed));
    }

    @Override
    @NotNull
    public Collection<DestinationSuggestionPacket> suggestDestinations(@NotNull CommandSender sender, @Nullable String destinationParams) {
        return List.of();
    }

    public static enum InstanceFailureReason implements FailureReason
    {
        INVALID_FORMAT(MVCorei18n.DESTINATION_CANNON_FAILUREREASON_INVALIDFORMAT),
        INVALID_COORDINATES_FORMAT(MVCorei18n.DESTINATION_SHARED_FAILUREREASON_INVALIDCOORDINATESFORMAT),
        INVALID_NUMBER_FORMAT(MVCorei18n.DESTINATION_SHARED_FAILUREREASON_INVALIDNUMBERFORMAT),
        WORLD_NOT_FOUND(MVCorei18n.DESTINATION_SHARED_FAILUREREASON_WORLDNOTFOUND);

        private final MessageKeyProvider messageKey;

        private InstanceFailureReason(MessageKeyProvider message) {
            this.messageKey = message;
        }

        @Override
        public MessageKey getMessageKey() {
            return this.messageKey.getMessageKey();
        }
    }
}

