/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.WorldType;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.PageFilterFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.display.ContentDisplay;
import org.mvplugins.multiverse.core.display.filters.DefaultContentFilter;
import org.mvplugins.multiverse.core.display.handlers.PagedSendHandler;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.display.parsers.MapContentProvider;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class InfoCommand
extends CoreCommand {
    private final LocationManipulation locationManipulation;
    private final MVEconomist economist;
    private final PageFilterFlags flags;

    @Inject
    InfoCommand(@NotNull LocationManipulation locationManipulation, @NotNull MVEconomist economist, @NotNull PageFilterFlags flags) {
        this.locationManipulation = locationManipulation;
        this.economist = economist;
        this.flags = flags;
    }

    @Subcommand(value="info")
    @CommandPermission(value="multiverse.core.info")
    @CommandCompletion(value="@mvworlds:scope=both|@flags:resolveUntil=arg1,groupName=pagefilter @flags:groupName=pagefilter")
    @Syntax(value="[world] [--page <page>] [--filter <filter>]")
    @Description(value="{@@mv-core.info.description}")
    public void onInfoCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware,maxArgForAware=0") @Syntax(value="[world]") @Description(value="{@@mv-core.info.description.world}") LoadedMultiverseWorld world, @Optional @Syntax(value="[--page <page>] [--filter <filter>]") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        ContentDisplay.create().addContent(MapContentProvider.forContent(this.getInfo(world)).withKeyColor(ChatColor.AQUA).withValueColor(ChatColor.WHITE)).withSendHandler((SendHandler)((PagedSendHandler)((PagedSendHandler)PagedSendHandler.create().withHeader(Message.of((MessageKeyProvider)MVCorei18n.INFO_HEADER, MessageReplacement.replace("{world}").with(world.getName())))).noContentMessage(Message.of((MessageKeyProvider)MVCorei18n.INFO_NOCONTENT, new MessageReplacement[0]))).doPagination(true).withTargetPage(parsedFlags.flagValue(this.flags.page, 1)).withFilter(parsedFlags.flagValue(this.flags.filter, DefaultContentFilter.get()))).send(issuer);
    }

    private Map<String, String> getInfo(LoadedMultiverseWorld world) {
        LinkedHashMap<String, String> outMap = new LinkedHashMap<String, String>();
        outMap.put("World Name", world.getName());
        outMap.put("World Alias", world.getAlias());
        outMap.put("World UID", world.getUID().toString());
        outMap.put("Game Mode", world.getGameMode().toString());
        outMap.put("Difficulty", world.getDifficulty().toString());
        outMap.put("Spawn Location", this.locationManipulation.strCoords(world.getSpawnLocation()));
        outMap.put("Respawn World", world.getRespawnWorldName());
        outMap.put("Bed Respawn", String.valueOf(world.getBedRespawn()));
        outMap.put("Anchor Respawn", String.valueOf(world.getAnchorRespawn()));
        outMap.put("Seed", String.valueOf(world.getSeed()));
        outMap.put("Environment", String.valueOf(world.getEnvironment()));
        outMap.put("World Type", (String)world.getWorldType().map(WorldType::getName).getOrNull());
        outMap.put("Biome", world.getBiome());
        outMap.put("Generator", world.getGenerator());
        outMap.put("Generate Structures", (String)world.canGenerateStructures().map(String::valueOf).getOrNull());
        outMap.put("Auto Load", String.valueOf(world.isAutoLoad()));
        outMap.put("Keep Spawn In Memory", String.valueOf(world.isKeepSpawnInMemory()));
        this.getEntryFeeInfo(outMap, world);
        outMap.put("World Scale", String.valueOf(world.getScale()));
        outMap.put("Weather Enabled", String.valueOf(world.isAllowWeather()));
        outMap.put("Allow Flight", String.valueOf(world.isAllowFlight()));
        outMap.put("Hunger Depletes", String.valueOf(world.isHunger()));
        outMap.put("Keep Spawn In Memory", String.valueOf(world.isKeepSpawnInMemory()));
        outMap.put("PVP Enabled", String.valueOf(world.getPvp()));
        outMap.put("Portal Form", String.valueOf((Object)world.getPortalForm()));
        outMap.put("Player Limit", String.valueOf(world.getPlayerLimit()));
        outMap.put("World Blacklist", String.join((CharSequence)", ", world.getWorldBlacklist()));
        return outMap;
    }

    private void getEntryFeeInfo(Map<String, String> outMap, MultiverseWorld world) {
        double price = world.getPrice();
        if (price == 0.0) {
            outMap.put("Entry Fee", "FREE!");
        } else if (price > 0.0) {
            outMap.put("Entry Fee", this.economist.formatPrice(price, world.getCurrency()));
        } else if (price < 0.0) {
            outMap.put("Entry Reward", this.economist.formatPrice(-price, world.getCurrency()));
        }
    }

    @Service
    private static final class LegacyAlias
    extends InfoCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull LocationManipulation locationManipulation, @NotNull MVEconomist economist, @NotNull PageFilterFlags flags) {
            super(locationManipulation, economist, flags);
        }

        @Override
        @CommandAlias(value="mvinfo|mvi")
        public void onInfoCommand(MVCommandIssuer issuer, LoadedMultiverseWorld world, String[] flags) {
            super.onInfoCommand(issuer, world, flags);
        }
    }
}

