/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command.flag;

import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagGroup;
import org.mvplugins.multiverse.core.command.flag.CommandValueFlag;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.external.acf.commands.InvalidCommandArgument;

public class CommandFlagsParser {
    private final CommandFlagGroup flagGroup;
    private final String[] flags;
    private ParsedCommandFlags parsedFlags;
    private boolean nextArgMayBeKey;
    private boolean nextArgMayBeValue;
    private CommandFlag currentFlag;

    public CommandFlagsParser(CommandFlagGroup flagGroup, String[] flags) {
        this.flagGroup = flagGroup;
        this.flags = flags;
    }

    public ParsedCommandFlags parse() {
        this.parsedFlags = new ParsedCommandFlags();
        this.nextArgMayBeKey = true;
        this.nextArgMayBeValue = false;
        for (String flag : this.flags) {
            if (this.nextArgMayBeKey && this.parseKey(flag) || this.nextArgMayBeValue && this.parseValue(flag)) continue;
            throw new InvalidCommandArgument(flag + " is not a valid flag.");
        }
        if (!this.nextArgMayBeKey && this.nextArgMayBeValue) {
            throw new InvalidCommandArgument(this.currentFlag.getKey() + " requires a value!");
        }
        return this.parsedFlags;
    }

    private boolean parseKey(String flag) {
        CommandFlag potentialFlag = this.flagGroup.getFlagByKey(flag);
        if (potentialFlag == null) {
            return false;
        }
        this.currentFlag = potentialFlag;
        CommandFlag commandFlag = this.currentFlag;
        if (commandFlag instanceof CommandValueFlag) {
            CommandValueFlag valueFlag = (CommandValueFlag)commandFlag;
            if (valueFlag.isOptional()) {
                this.parsedFlags.addFlagResult(valueFlag.getKey(), valueFlag.getDefaultValue());
                this.nextArgMayBeKey = true;
                this.nextArgMayBeValue = true;
                return true;
            }
            this.nextArgMayBeKey = false;
            this.nextArgMayBeValue = true;
            return true;
        }
        this.parsedFlags.addFlagResult(this.currentFlag.getKey(), null);
        this.nextArgMayBeKey = true;
        this.nextArgMayBeValue = false;
        return true;
    }

    private boolean parseValue(String flag) {
        if (this.currentFlag == null) {
            throw new InvalidCommandArgument("Some flag logic error occurred at '" + flag + "'!");
        }
        if (this.flagGroup.hasKey(flag)) {
            throw new InvalidCommandArgument(this.currentFlag.getKey() + " requires a value!");
        }
        CommandValueFlag valueFlag = (CommandValueFlag)this.currentFlag;
        String flagValue = valueFlag.getContext() != null ? valueFlag.getContext().apply(flag) : flag;
        this.parsedFlags.addFlagResult(valueFlag.getKey(), flagValue);
        this.nextArgMayBeKey = true;
        this.nextArgMayBeValue = false;
        this.currentFlag = null;
        return true;
    }
}

