/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command;

import org.bukkit.command.CommandSender;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.text.ChatTextFormatter;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.BukkitMessageFormatter;
import org.mvplugins.multiverse.external.acf.commands.MessageType;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class MVCommandIssuer
extends BukkitCommandIssuer {
    private final MVCommandManager commandManager;

    MVCommandIssuer(@NotNull MVCommandManager commandManager, @NotNull CommandSender sender) {
        super(commandManager, sender);
        this.commandManager = commandManager;
    }

    @Override
    public MVCommandManager getManager() {
        return this.commandManager;
    }

    @Override
    public void sendMessageInternal(String message) {
        ChatTextFormatter.sendFormattedMessage(this.getIssuer(), message);
    }

    public void sendError(String message, MessageReplacement ... replacements) {
        this.sendMessage(MessageType.ERROR, message, replacements);
    }

    public void sendSyntax(String message, MessageReplacement ... replacements) {
        this.sendMessage(MessageType.SYNTAX, message, replacements);
    }

    public void sendInfo(String message, MessageReplacement ... replacements) {
        this.sendMessage(MessageType.INFO, message, replacements);
    }

    public void sendMessage(String message, MessageReplacement ... replacements) {
        this.sendMessage(null, Message.of(message, replacements));
    }

    public void sendMessage(MessageType type, String message, MessageReplacement ... replacements) {
        this.sendMessage(type, Message.of(message, replacements));
    }

    public void sendMessage(MessageType messageType, String message) {
        BukkitMessageFormatter formatter = (BukkitMessageFormatter)this.getManager().getFormat(messageType);
        if (formatter != null) {
            this.sendMessage(formatter.format(message));
        } else {
            this.sendMessage(message);
        }
    }

    public void sendError(MessageKeyProvider key) {
        this.sendMessage(MessageType.ERROR, key, new String[0]);
    }

    public void sendSyntax(MessageKeyProvider key) {
        this.sendMessage(MessageType.SYNTAX, key, new String[0]);
    }

    public void sendInfo(MessageKeyProvider key) {
        this.sendMessage(MessageType.INFO, key, new String[0]);
    }

    public void sendError(MessageKeyProvider key, MessageReplacement ... replacements) {
        this.sendMessage(MessageType.ERROR, key, replacements);
    }

    public void sendSyntax(MessageKeyProvider key, MessageReplacement ... replacements) {
        this.sendMessage(MessageType.SYNTAX, key, replacements);
    }

    public void sendInfo(MessageKeyProvider key, MessageReplacement ... replacements) {
        this.sendMessage(MessageType.INFO, key, replacements);
    }

    public void sendMessage(MessageKeyProvider key, MessageReplacement ... replacements) {
        this.sendMessage(null, Message.of(key, replacements));
    }

    public void sendMessage(MessageType messageType, MessageKeyProvider key, MessageReplacement ... replacements) {
        this.sendMessage(messageType, Message.of(key, replacements));
    }

    public void sendError(Message message) {
        this.sendMessage(MessageType.ERROR, message);
    }

    public void sendSyntax(Message message) {
        this.sendMessage(MessageType.SYNTAX, message);
    }

    public void sendInfo(Message message) {
        this.sendMessage(MessageType.INFO, message);
    }

    public void sendMessage(Message message) {
        this.sendMessage(null, message);
    }

    public void sendMessage(MessageType messageType, Message message) {
        if (message instanceof MessageKeyProvider) {
            this.sendMessage(messageType, (MessageKeyProvider)((Object)message), message.getReplacements(this.getManager().getLocales(), this));
        } else {
            BukkitMessageFormatter formatter = (BukkitMessageFormatter)this.getManager().getFormat(messageType);
            if (formatter != null) {
                this.sendMessage(formatter.format(message.formatted(this.getManager().getLocales(), this)));
            } else {
                this.sendMessage(message.formatted(this.getManager().getLocales(), this));
            }
        }
    }
}

