/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command;

import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.helpers.WorldNameChecker;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandExecutionContext;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.CommandConditions;
import org.mvplugins.multiverse.external.acf.commands.ConditionContext;
import org.mvplugins.multiverse.external.acf.commands.ConditionFailedException;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class MVCommandConditions {
    private final WorldManager worldManager;
    private final MVCommandManager commandManager;
    private final WorldNameChecker worldNameChecker;

    static void load(@NotNull MVCommandManager commandManager, @NotNull WorldManager worldManager, @NotNull WorldNameChecker worldNameChecker) {
        MVCommandConditions mvCommandConditions = new MVCommandConditions(commandManager, worldManager, worldNameChecker);
        mvCommandConditions.registerConditions();
    }

    private MVCommandConditions(@NotNull MVCommandManager commandManager, @NotNull WorldManager worldManager, @NotNull WorldNameChecker worldNameChecker) {
        this.worldManager = worldManager;
        this.commandManager = commandManager;
        this.worldNameChecker = worldNameChecker;
    }

    private void registerConditions() {
        CommandConditions conditions = this.commandManager.getCommandConditions();
        conditions.addCondition(String.class, "worldname", this::checkWorldname);
    }

    private void checkWorldname(ConditionContext<BukkitCommandIssuer> context, BukkitCommandExecutionContext executionContext, String worldName) {
        String scope;
        switch (scope = context.getConfigValue("scope", "loaded")) {
            case "loaded": {
                if (this.worldManager.isLoadedWorld(worldName)) break;
                throw new ConditionFailedException("World with name '" + worldName + "' does not exist or is not loaded!");
            }
            case "unloaded": {
                if (this.worldManager.isUnloadedWorld(worldName)) break;
                if (this.worldManager.isLoadedWorld(worldName)) {
                    throw new ConditionFailedException("World with name '" + worldName + "' is loaded already!");
                }
                throw new ConditionFailedException("World with name '" + worldName + "' does not exist!");
            }
            case "both": {
                if (this.worldManager.isWorld(worldName)) break;
                throw new ConditionFailedException("World with name '" + worldName + "' does not exist!");
            }
            case "new": {
                if (this.worldManager.isWorld(worldName)) {
                    throw new ConditionFailedException("World with name '" + worldName + "' already exists!");
                }
                switch (this.worldNameChecker.checkName(worldName)) {
                    case INVALID_CHARS: {
                        throw new ConditionFailedException("World name '" + worldName + "' contains invalid characters!");
                    }
                    case BLACKLISTED: {
                        throw new ConditionFailedException("World name '" + worldName + "' is used for critical server operations and is blacklisted!");
                    }
                }
                break;
            }
            default: {
                throw new ConditionFailedException("Unknown scope '" + scope + "'!");
            }
        }
    }
}

