/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.anchor;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.anchor.MultiverseAnchor;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.result.Result;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.entrycheck.WorldEntryCheckerProvider;
import org.mvplugins.multiverse.core.world.location.UnloadedWorldLocation;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public final class AnchorManager {
    private static final String ANCHORS_FILE = "anchors.yml";
    private static final String ANCHORS_CONFIG_SECTION = "anchors";
    private final Map<String, MultiverseAnchor> anchors;
    private FileConfiguration anchorConfig;
    private final Plugin plugin;
    private final LocationManipulation locationManipulation;
    private final WorldEntryCheckerProvider entryCheckerProvider;
    private final WorldManager worldManager;

    @Inject
    AnchorManager(MultiverseCore plugin, LocationManipulation locationManipulation, WorldEntryCheckerProvider entryCheckerProvider, WorldManager worldManager) {
        this.plugin = plugin;
        this.locationManipulation = locationManipulation;
        this.entryCheckerProvider = entryCheckerProvider;
        this.worldManager = worldManager;
        this.anchors = new HashMap<String, MultiverseAnchor>();
    }

    public Try<Void> loadAnchors() {
        this.anchors.clear();
        return Try.run(() -> {
            this.anchorConfig = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), ANCHORS_FILE));
            this.parseAnchorsFromConfig();
        });
    }

    private void parseAnchorsFromConfig() {
        ConfigurationSection anchorsSection = this.getAnchorsConfigSection();
        Set anchorKeys = anchorsSection.getKeys(false);
        for (String key : anchorKeys) {
            Location anchorLocation = this.locationManipulation.stringToLocation(anchorsSection.getString(key, ""));
            if (anchorLocation != null) {
                CoreLogging.config("Loading anchor:  '%s'...", key);
                this.anchors.put(key, new MultiverseAnchor(key, UnloadedWorldLocation.fromLocation(anchorLocation)));
                continue;
            }
            CoreLogging.warning("The location for anchor '%s' is INVALID.", key);
        }
    }

    private ConfigurationSection getAnchorsConfigSection() {
        ConfigurationSection anchorsConfigSection = this.anchorConfig.getConfigurationSection(ANCHORS_CONFIG_SECTION);
        if (anchorsConfigSection == null) {
            anchorsConfigSection = this.anchorConfig.createSection(ANCHORS_CONFIG_SECTION);
        }
        return anchorsConfigSection;
    }

    public Try<Void> saveAllAnchors() {
        return Try.run(() -> this.anchorConfig.save(new File(this.plugin.getDataFolder(), ANCHORS_FILE))).onFailure(failure -> CoreLogging.severe("Failed to save anchors.yml. Please check your file permissions.", new Object[0]));
    }

    public Option<MultiverseAnchor> getAnchor(String anchorName) {
        return Option.of(this.anchors.get(anchorName));
    }

    public Try<Void> setAnchor(@NotNull String anchorName, @NotNull String location) {
        Location parsed = this.locationManipulation.stringToLocation(location);
        if (parsed == null) {
            return Try.failure(new IllegalArgumentException("The location for anchor '" + anchorName + "' is INVALID."));
        }
        return this.setAnchor(anchorName, parsed);
    }

    public Try<Void> setAnchor(@NotNull String anchorName, @NotNull Location location) {
        Option.of(this.anchors.get(anchorName)).peek(anchor -> anchor.setLocation(UnloadedWorldLocation.fromLocation(location))).onEmpty(() -> this.anchors.put(anchorName, new MultiverseAnchor(anchorName, UnloadedWorldLocation.fromLocation(location))));
        this.getAnchorsConfigSection().set(anchorName, (Object)this.locationManipulation.locationToString(location));
        return this.saveAllAnchors();
    }

    public List<MultiverseAnchor> getAllAnchors() {
        return this.anchors.values().stream().toList();
    }

    public List<MultiverseAnchor> getAnchors(@Nullable Player player) {
        if (player == null) {
            return this.getAllAnchors();
        }
        return this.getAnchorsForPlayer(player);
    }

    private List<MultiverseAnchor> getAnchorsForPlayer(@NotNull Player player) {
        return this.anchors.values().stream().filter(anchor -> this.shouldIncludeAnchorForPlayer((MultiverseAnchor)anchor, player)).toList();
    }

    private boolean shouldIncludeAnchorForPlayer(MultiverseAnchor anchor, Player player) {
        return this.worldManager.getWorld(anchor.getLocationWorld()).map(mvWorld -> this.entryCheckerProvider.forSender((CommandSender)player).canAccessWorld((MultiverseWorld)mvWorld)).peek(result -> CoreLogging.finer("Result for %s can access anchor %s: %s", player.getName(), anchor.getName(), result)).map(Result::isSuccess).getOrElse(true);
    }

    public Try<Void> deleteAnchor(@NotNull MultiverseAnchor anchor) {
        if (this.anchors.containsKey(anchor.getName())) {
            this.anchors.remove(anchor.getName());
            this.getAnchorsConfigSection().set(anchor.getName(), null);
            return this.saveAllAnchors();
        }
        return Try.failure(new IllegalArgumentException("Anchor does not exist"));
    }
}

