/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.BstatsMetricsConfigurator;
import org.mvplugins.multiverse.core.MultiverseCoreApi;
import org.mvplugins.multiverse.core.MultiverseCorePluginBinder;
import org.mvplugins.multiverse.core.PlaceholderExpansionHook;
import org.mvplugins.multiverse.core.TestingMode;
import org.mvplugins.multiverse.core.anchor.AnchorManager;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.inject.PluginServiceLocatorFactory;
import org.mvplugins.multiverse.core.listeners.CoreListener;
import org.mvplugins.multiverse.core.module.MultiverseModule;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.location.NullSpawnLocation;
import org.mvplugins.multiverse.core.world.location.SpawnLocation;
import org.mvplugins.multiverse.core.world.location.UnloadedWorldLocation;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jakarta.inject.Provider;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public class MultiverseCore
extends MultiverseModule {
    @Inject
    private Provider<CoreConfig> configProvider;
    @Inject
    private Provider<WorldManager> worldManagerProvider;
    @Inject
    private Provider<AnchorManager> anchorManagerProvider;
    @Inject
    private Provider<DestinationsProvider> destinationsProviderProvider;
    @Inject
    private Provider<BstatsMetricsConfigurator> metricsConfiguratorProvider;
    @Inject
    private Provider<MVEconomist> economistProvider;

    public void onLoad() {
        CoreLogging.init((Plugin)this);
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
            CoreLogging.severe("Failed to create data folder!", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        ConfigurationSerialization.registerClass(NullSpawnLocation.class);
        ConfigurationSerialization.registerClass(SpawnLocation.class);
        ConfigurationSerialization.registerClass(UnloadedWorldLocation.class);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.initializeDependencyInjection(new MultiverseCorePluginBinder(this));
        CoreConfig config = this.configProvider.get();
        boolean loadSuccess = config.load().andThenTry(config::save).isSuccess();
        if (!loadSuccess || !config.isLoaded()) {
            CoreLogging.severe("Your configs were not loaded.", new Object[0]);
            CoreLogging.severe("Please check your configs and restart the server.", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        CoreLogging.setShowingConfig(this.shouldShowConfig());
        this.worldManagerProvider.get().initAllWorlds().andThenTry(() -> {
            this.loadEconomist();
            this.loadAnchors();
            this.registerDynamicListeners(CoreListener.class);
            this.setUpLocales();
            this.registerCommands(CoreCommand.class);
            this.registerDestinations();
            this.setupMetrics();
            this.loadPlaceholderApiIntegration();
            this.loadApiService();
            this.saveAllConfigs();
            this.logEnableMessage();
        }).onFailure(e -> {
            CoreLogging.severe("Failed to multiverse core! Disabling...", new Object[0]);
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        });
    }

    @Override
    public void onDisable() {
        super.onDisable();
        MultiverseCoreApi.shutdown();
        this.shutdownDependencyInjection();
        PluginServiceLocatorFactory.get().shutdown();
        CoreLogging.shutdown();
    }

    private boolean shouldShowConfig() {
        return !this.configProvider.get().getSilentStart();
    }

    private void loadEconomist() {
        Try.run(() -> this.economistProvider.get()).onFailure(e -> {
            CoreLogging.severe("Failed to load economy integration", new Object[0]);
            e.printStackTrace();
        });
    }

    private void loadAnchors() {
        Try.of(() -> this.anchorManagerProvider.get()).flatMap(AnchorManager::loadAnchors).onFailure(e -> {
            CoreLogging.severe("Failed to load anchors", new Object[0]);
            e.printStackTrace();
        });
    }

    private void registerDestinations() {
        Try.of(() -> this.destinationsProviderProvider.get()).andThenTry(destinationsProvider -> this.serviceLocator.getAllServices(Destination.class, new Annotation[0]).forEach(destinationsProvider::registerDestination)).onFailure(e -> {
            CoreLogging.severe("Failed to register destinations", new Object[0]);
            e.printStackTrace();
        });
    }

    private void setupMetrics() {
        if (TestingMode.isDisabled()) {
            Try.of(() -> this.metricsConfiguratorProvider.get()).onFailure(e -> {
                CoreLogging.severe("Failed to setup metrics", new Object[0]);
                e.printStackTrace();
            });
        } else {
            CoreLogging.info("Metrics are disabled in testing mode.", new Object[0]);
        }
    }

    private void loadPlaceholderApiIntegration() {
        if (this.configProvider.get().isRegisterPapiHook() && this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            Try.run(() -> this.serviceLocator.getService(PlaceholderExpansionHook.class, new Annotation[0])).onFailure(e -> {
                CoreLogging.severe("Failed to load PlaceholderAPI integration.", new Object[0]);
                e.printStackTrace();
            });
        }
    }

    private void loadApiService() {
        Try.run(() -> MultiverseCoreApi.init(this)).onSuccess(ignore -> CoreLogging.info("API service loaded!", new Object[0])).onFailure(e -> {
            CoreLogging.severe("Failed to load API service!", new Object[0]);
            e.printStackTrace();
        });
    }

    private Try<Void> saveAllConfigs() {
        return this.configProvider.get().save().andThenTry(() -> this.worldManagerProvider.get().saveWorldsConfig()).andThenTry(() -> this.anchorManagerProvider.get().saveAllAnchors()).onFailure(e -> CoreLogging.severe("Failed to save all configs, things may not work as expected. %s", e.getLocalizedMessage()));
    }

    private void logEnableMessage() {
        CoreLogging.config("\u001b[32mVersion %s (API v%s) Enabled - By %s\u001b[39m", this.getDescription().getVersion(), this.getVersionAsNumber(), StringFormatter.joinAnd(this.getDescription().getAuthors()));
        if (this.configProvider.get().isShowingDonateMessage()) {
            CoreLogging.config("\u001b[32mLoving Multiverse-Core? Please consider supporting the project with a small donation: https://github.com/sponsors/Multiverse\u001b[39m", new Object[0]);
        }
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public MultiverseCoreApi getApi() {
        return MultiverseCoreApi.get();
    }

    @Override
    public double getTargetCoreVersion() {
        return this.getVersionAsNumber();
    }

    @NotNull
    public Logger getLogger() {
        return CoreLogging.getLogger();
    }

    @NotNull
    public FileConfiguration getConfig() {
        CoreConfig coreConfig = this.configProvider.get();
        FileConfiguration config = coreConfig.getConfig();
        if (config != null && coreConfig.isLoaded()) {
            return config;
        }
        boolean loadSuccess = coreConfig.load().isSuccess();
        if (!loadSuccess || !coreConfig.isLoaded()) {
            throw new RuntimeException("Failed to load configs");
        }
        return coreConfig.getConfig();
    }

    public void reloadConfig() {
        this.configProvider.get().load();
    }

    public void saveConfig() {
        this.configProvider.get().save();
    }
}

