/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.apache.commons.lang3.text.WordUtils;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.bstats.bukkit.Metrics;
import org.mvplugins.multiverse.external.bstats.charts.AdvancedPie;
import org.mvplugins.multiverse.external.bstats.charts.SingleLineChart;
import org.mvplugins.multiverse.external.jakarta.annotation.PostConstruct;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class BstatsMetricsConfigurator {
    private static final int PLUGIN_ID = 7765;
    private static final String NO_GENERATOR_NAME = "N/A";
    private final WorldManager worldManager;
    private final Metrics metrics;

    @Inject
    private BstatsMetricsConfigurator(MultiverseCore plugin, WorldManager worldManager) {
        this.worldManager = worldManager;
        this.metrics = new Metrics((Plugin)plugin, 7765);
    }

    @PostConstruct
    private void initMetrics() {
        try {
            this.addCustomGeneratorsMetric();
            this.addEnvironmentsMetric();
            this.addWorldCountMetric();
            CoreLogging.fine("Metrics enabled.", new Object[0]);
        }
        catch (Exception e) {
            CoreLogging.warning("There was an issue while enabling metrics:", new Object[0]);
            e.printStackTrace();
        }
    }

    private void addCustomGeneratorsMetric() {
        this.addAdvancedPieMetric("custom_generators", map -> {
            for (MultiverseWorld multiverseWorld : this.worldManager.getLoadedWorlds()) {
                this.incrementCount((Map<String, Integer>)map, this.getGeneratorName(multiverseWorld));
            }
        });
    }

    private String getGeneratorName(MultiverseWorld world) {
        String gen = world.getGenerator();
        return gen != null && !gen.equalsIgnoreCase("null") ? REPatterns.COLON.split(gen)[0] : NO_GENERATOR_NAME;
    }

    private void addEnvironmentsMetric() {
        this.addAdvancedPieMetric("environments", map -> {
            for (MultiverseWorld multiverseWorld : this.worldManager.getLoadedWorlds()) {
                this.incrementCount((Map<String, Integer>)map, this.titleCaseEnv(multiverseWorld.getEnvironment()));
            }
        });
    }

    private String titleCaseEnv(World.Environment env) {
        String envName = env.name().replaceAll("_+", " ");
        return WordUtils.capitalizeFully((String)envName);
    }

    private void addWorldCountMetric() {
        this.addLineMetric("worlds", () -> this.worldManager.getWorlds().size());
    }

    private void addAdvancedPieMetric(String chartId, Consumer<Map<String, Integer>> metricsFunc) {
        this.metrics.addCustomChart(this.createAdvancedPieChart(chartId, metricsFunc));
    }

    private void addLineMetric(String chartId, Callable<Integer> metricsFunc) {
        this.metrics.addCustomChart(this.createLineChart(chartId, metricsFunc));
    }

    private void incrementCount(Map<String, Integer> map, String key) {
        Integer count = map.getOrDefault(key, 0);
        map.put(key, count + 1);
    }

    private AdvancedPie createAdvancedPieChart(String chartId, Consumer<Map<String, Integer>> metricsFunc) {
        HashMap map = new HashMap();
        metricsFunc.accept(map);
        return new AdvancedPie(chartId, () -> map);
    }

    private SingleLineChart createLineChart(String chartId, Callable<Integer> metricsFunc) {
        return new SingleLineChart(chartId, metricsFunc);
    }
}

