/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mvplugins.multiverse.core.utils.matcher.ExactStringMatcher;
import org.mvplugins.multiverse.core.utils.matcher.StringMatcher;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

@ApiStatus.AvailableSince(value="5.2")
public class MatcherGroup
implements StringMatcher {
    private final ExactStringMatcher exactMatcher = new ExactStringMatcher();
    private final List<StringMatcher> stringMatchers = new ArrayList<StringMatcher>();

    @ApiStatus.AvailableSince(value="5.2")
    public MatcherGroup() {
    }

    @ApiStatus.AvailableSince(value="5.2")
    public MatcherGroup(@NotNull Collection<String> matchStrings) {
        this();
        for (String matchString : matchStrings) {
            this.addMatcher(matchString);
        }
    }

    @ApiStatus.AvailableSince(value="5.2")
    public void addMatcher(@Nullable String matchString) {
        if (matchString == null || matchString.isEmpty()) {
            return;
        }
        if (this.isExact(matchString)) {
            this.exactMatcher.addExactMatch(matchString);
        } else {
            this.stringMatchers.add(StringMatcher.fromString(matchString));
        }
    }

    private boolean isExact(@NotNull String matcherString) {
        return !matcherString.contains("*") && !matcherString.startsWith("r=");
    }

    @ApiStatus.AvailableSince(value="5.2")
    public void addMatcher(@NotNull StringMatcher matcher) {
        this.stringMatchers.add(matcher);
    }

    @Override
    public boolean matches(@Nullable String value) {
        if (this.exactMatcher.matches(value)) {
            return true;
        }
        for (StringMatcher matcher : this.stringMatchers) {
            if (!matcher.matches(value)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "MatcherGroup{exactMatcher=" + String.valueOf(this.exactMatcher) + ", stringMatchers=" + String.valueOf(this.stringMatchers) + "}";
    }
}

