/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.listeners;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.DefaultEventPriority;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventPriorityKey;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.event.MVRespawnEvent;
import org.mvplugins.multiverse.core.listeners.CoreListener;
import org.mvplugins.multiverse.core.locale.PluginLocales;
import org.mvplugins.multiverse.core.permissions.CorePermissionsChecker;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.core.teleportation.TeleportQueue;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.result.ResultChain;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.entrycheck.EntryFeeResult;
import org.mvplugins.multiverse.core.world.entrycheck.WorldEntryCheckerProvider;
import org.mvplugins.multiverse.core.world.helpers.DimensionFinder;
import org.mvplugins.multiverse.core.world.helpers.EnforcementHandler;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jakarta.inject.Provider;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
final class MVPlayerListener
implements CoreListener {
    private final Plugin plugin;
    private final CoreConfig config;
    private final Provider<WorldManager> worldManagerProvider;
    private final BlockSafety blockSafety;
    private final Server server;
    private final TeleportQueue teleportQueue;
    private final MVEconomist economist;
    private final WorldEntryCheckerProvider worldEntryCheckerProvider;
    private final Provider<MVCommandManager> commandManagerProvider;
    private final DestinationsProvider destinationsProvider;
    private final EnforcementHandler enforcementHandler;
    private final DimensionFinder dimensionFinder;
    private final CorePermissionsChecker corePermissionsChecker;
    private final AsyncSafetyTeleporter asyncSafetyTeleporter;
    private final Map<String, String> playerWorld = new ConcurrentHashMap<String, String>();

    @Inject
    MVPlayerListener(MultiverseCore plugin, CoreConfig config, Provider<WorldManager> worldManagerProvider, BlockSafety blockSafety, Server server, TeleportQueue teleportQueue, MVEconomist economist, WorldEntryCheckerProvider worldEntryCheckerProvider, Provider<MVCommandManager> commandManagerProvider, DestinationsProvider destinationsProvider, EnforcementHandler enforcementHandler, DimensionFinder dimensionFinder, CorePermissionsChecker corePermissionsChecker, AsyncSafetyTeleporter asyncSafetyTeleporter) {
        this.plugin = plugin;
        this.config = config;
        this.worldManagerProvider = worldManagerProvider;
        this.blockSafety = blockSafety;
        this.server = server;
        this.teleportQueue = teleportQueue;
        this.economist = economist;
        this.worldEntryCheckerProvider = worldEntryCheckerProvider;
        this.commandManagerProvider = commandManagerProvider;
        this.destinationsProvider = destinationsProvider;
        this.enforcementHandler = enforcementHandler;
        this.dimensionFinder = dimensionFinder;
        this.corePermissionsChecker = corePermissionsChecker;
        this.asyncSafetyTeleporter = asyncSafetyTeleporter;
    }

    private WorldManager getWorldManager() {
        return this.worldManagerProvider.get();
    }

    private MVCommandManager getCommandManager() {
        return this.commandManagerProvider.get();
    }

    private PluginLocales getLocales() {
        return this.getCommandManager().getLocales();
    }

    Map<String, String> getPlayerWorld() {
        return this.playerWorld;
    }

    @EventMethod
    @EventPriorityKey(value="mvcore-player-respawn")
    @DefaultEventPriority(value=EventPriority.LOW)
    void playerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        LoadedMultiverseWorld mvWorld = (LoadedMultiverseWorld)this.getWorldManager().getLoadedWorld(player.getWorld()).getOrNull();
        if (mvWorld == null) {
            CoreLogging.finer("Player '%s' died in a world that is not managed by Multiverse.", player.getName());
            return;
        }
        if (mvWorld.getBedRespawn() && event.isBedSpawn()) {
            CoreLogging.fine("Spawning %s at their bed.", player.getName());
            return;
        }
        if (mvWorld.getAnchorRespawn() && event.isAnchorSpawn()) {
            CoreLogging.fine("Spawning %s at their anchor.", player.getName());
            return;
        }
        this.getRespawnWorld(mvWorld).onEmpty(() -> CoreLogging.fine("No respawn-world determined for world '%s'.", mvWorld.getName())).flatMap(respawnWorld -> {
            CoreLogging.finer("Using respawn-world '%s' for world '%s'.", respawnWorld.getName(), mvWorld.getName());
            return this.getMostAccurateRespawnLocation((LoadedMultiverseWorld)respawnWorld, event.getRespawnLocation()).onEmpty(() -> CoreLogging.finer("No accurate respawn-location determined for world '%s'.", mvWorld.getName()));
        }).peek(newRespawnLocation -> {
            MVRespawnEvent respawnEvent = new MVRespawnEvent((Location)newRespawnLocation, event.getPlayer());
            this.server.getPluginManager().callEvent((Event)respawnEvent);
            if (respawnEvent.isCancelled()) {
                CoreLogging.fine("Player '%s' cancelled their respawn event.", player.getName());
                return;
            }
            CoreLogging.fine("Overriding respawn location for player '%s' to '%s'.", player.getName(), respawnEvent.getRespawnLocation());
            event.setRespawnLocation(respawnEvent.getRespawnLocation());
        });
    }

    private Option<LoadedMultiverseWorld> getRespawnWorld(LoadedMultiverseWorld mvWorld) {
        if (!mvWorld.getRespawnWorldName().isEmpty()) {
            CoreLogging.finer("Using configured respawn-world for world '%s'.", mvWorld.getName());
            return this.getWorldManager().getLoadedWorld(mvWorld.getRespawnWorldName()).onEmpty(() -> CoreLogging.warning("World '%s' has respawn-world property of '%s' that does not exist!", mvWorld.getName(), mvWorld.getRespawnWorldName()));
        }
        if (!this.dimensionFinder.isOverworld(mvWorld) && this.config.getDefaultRespawnInOverworld()) {
            CoreLogging.finer("Defaulting to overworld for world '%s'.", mvWorld.getName());
            return this.dimensionFinder.getOverworldWorld(mvWorld).flatMap(this.getWorldManager()::getLoadedWorld).onEmpty(() -> CoreLogging.warning("World '%s' has no overworld to teleport to!", mvWorld.getName()));
        }
        if (this.config.getDefaultRespawnWithinSameWorld()) {
            CoreLogging.finer("Defaulting to same world for world '%s'.", mvWorld.getName());
            return Option.of(mvWorld);
        }
        return Option.none();
    }

    private Option<Location> getMostAccurateRespawnLocation(LoadedMultiverseWorld mvWorld, Location defaultRespawnLocation) {
        if (!this.config.getEnforceRespawnAtWorldSpawn() && Objects.equals(defaultRespawnLocation.getWorld(), mvWorld.getBukkitWorld().getOrNull())) {
            CoreLogging.fine("Respawn location is within same world as respawn-world, not overriding.", new Object[0]);
            return Option.none();
        }
        return Option.of(mvWorld.getSpawnLocation());
    }

    @EventMethod
    @EventPriorityKey(value="mvcore-player-spawn-location")
    void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPlayedBefore()) {
            this.handleJoinLocation(player);
        } else {
            this.handleFirstSpawn(player);
        }
        this.handleGameModeAndFlight(player, player.getWorld());
    }

    private void handleFirstSpawn(Player player) {
        if (!this.config.getFirstSpawnOverride()) {
            CoreLogging.finer("FirstSpawnOverride is disabled", new Object[0]);
            return;
        }
        CoreLogging.fine("Moving NEW player to(firstspawnoverride): %s", this.config.getFirstSpawnLocation());
        this.destinationsProvider.parseDestination(this.config.getFirstSpawnLocation()).peek(destination -> this.teleportToDestinationOnJoin(player, (DestinationInstance<?, ?>)destination)).onFailure(failure -> {
            CoreLogging.warning("Invalid destination in FirstSpawnLocation in config: %s", new Object[0]);
            CoreLogging.warning(failure.getFailureMessage().formatted(this.getLocales()), new Object[0]);
        });
    }

    private void handleJoinLocation(Player player) {
        if (!this.config.getEnableJoinDestination()) {
            CoreLogging.finer("JoinDestination is disabled", new Object[0]);
            return;
        }
        if (this.config.getJoinDestination().isBlank()) {
            CoreLogging.warning("Joindestination is enabled but no destination has been specified in config!", new Object[0]);
            return;
        }
        if (this.corePermissionsChecker.hasJoinLocationBypassPermission((CommandSender)player)) {
            CoreLogging.finer("Player %s has bypass permission for JoinDestination", player.getName());
            return;
        }
        CoreLogging.finer("JoinDestination is " + this.config.getJoinDestination(), new Object[0]);
        this.destinationsProvider.parseDestination(this.config.getJoinDestination()).peek(destination -> this.teleportToDestinationOnJoin(player, (DestinationInstance<?, ?>)destination)).onFailure(failure -> {
            CoreLogging.warning("Invalid destination in JoinDestination in config: %s", new Object[0]);
            CoreLogging.warning(failure.getFailureMessage().formatted(this.getLocales()), new Object[0]);
        });
    }

    private void teleportToDestinationOnJoin(Player player, DestinationInstance<?, ?> destination) {
        this.asyncSafetyTeleporter.to(destination).teleportSingle((Entity)player).onSuccess(result -> CoreLogging.fine("Player %s has been teleported on join", player.getName())).onFailure(failure -> CoreLogging.warning("Failed to teleport player %s on join: %s", player.getName(), failure.get(0)));
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    void playerChangedWorld(PlayerChangedWorldEvent event) {
        this.handleGameModeAndFlight(event.getPlayer(), event.getPlayer().getWorld());
        this.playerWorld.put(event.getPlayer().getName(), event.getPlayer().getWorld().getName());
    }

    @EventMethod
    @EventPriorityKey(value="mvcore-player-teleport")
    @DefaultEventPriority(value=EventPriority.HIGHEST)
    void playerTeleport(PlayerTeleportEvent event) {
        CoreLogging.finer("Got teleport event for player '" + event.getPlayer().getName() + "' with cause '" + String.valueOf(event.getCause()) + "'", new Object[0]);
        if (event.isCancelled()) {
            return;
        }
        Player teleportee = event.getPlayer();
        Option<String> teleporterName = this.teleportQueue.popFromQueue(teleportee.getName());
        CommandSender teleporter = (CommandSender)teleporterName.map(name -> {
            if (name.equalsIgnoreCase("CONSOLE")) {
                CoreLogging.finer("We know the teleporter is the console! Magical!", new Object[0]);
                return this.server.getConsoleSender();
            }
            return this.server.getPlayerExact((String)teleporterName.get());
        }).getOrNull();
        if (teleporter == null) {
            if (!this.config.getTeleportIntercept()) {
                CoreLogging.finer("Teleport for %s was not initiated by multiverse and teleport intercept is disabled. Ignoring...", teleportee.getName());
                return;
            }
            CoreLogging.finer("Unknown teleporter for teleport for %s. Using player as teleporter.", teleportee.getName());
            teleporter = teleportee;
        }
        CoreLogging.finer("Teleporter %s is teleporting %s from %s to %s", teleporter.getName(), teleportee.getName(), event.getFrom(), event.getTo());
        MultiverseWorld fromWorld = (MultiverseWorld)this.getWorldManager().getLoadedWorld(event.getFrom().getWorld()).getOrNull();
        LoadedMultiverseWorld toWorld = (LoadedMultiverseWorld)this.getWorldManager().getLoadedWorld(event.getTo().getWorld()).getOrNull();
        if (toWorld == null) {
            CoreLogging.fine("Player '" + teleportee.getName() + "' is teleporting to world '" + event.getTo().getWorld().getName() + "' which is not managed by Multiverse-Core.  No further actions will be taken by Multiverse-Core.", new Object[0]);
            return;
        }
        if (event.getFrom().getWorld().equals((Object)event.getTo().getWorld())) {
            CoreLogging.finer("Player '" + teleportee.getName() + "' is teleporting to the same world.", new Object[0]);
            this.stateSuccess(teleportee.getName(), toWorld.getName());
            return;
        }
        CommandSender finalTeleporter = teleporter;
        ResultChain entryResult = this.worldEntryCheckerProvider.forSender(finalTeleporter).canEnterWorld(fromWorld, toWorld).onSuccessReason(EntryFeeResult.Success.class, reason -> {
            if (reason == EntryFeeResult.Success.ENOUGH_MONEY) {
                this.economist.payEntryFee((Player)finalTeleporter, toWorld);
            }
        }).onFailure(results -> {
            event.setCancelled(true);
            this.getCommandManager().getCommandIssuer(finalTeleporter).sendError(results.getLastResultMessage());
        });
        CoreLogging.fine("Teleport result: %s", entryResult);
    }

    private void stateSuccess(String playerName, String worldName) {
        CoreLogging.fine("MV-Core is allowing Player '" + playerName + "' to go to '" + worldName + "'.", new Object[0]);
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.LOWEST)
    void playerPortalCheck(PlayerPortalEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getFrom().getWorld() == null) {
            CoreLogging.warning("PlayerPortalEvent's from world is null!", new Object[0]);
            return;
        }
        if (event.getFrom().getWorld().getBlockAt(event.getFrom()).getType() == Material.NETHER_PORTAL) {
            return;
        }
        Location newLocation = this.blockSafety.findPortalBlockNextTo(event.getFrom());
        if (newLocation != null) {
            event.setFrom(newLocation);
        }
    }

    @EventMethod
    @EventPriorityKey(value="mvcore-player-portal")
    @DefaultEventPriority(value=EventPriority.HIGH)
    void playerPortal(PlayerPortalEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getTo() == null || event.getTo().getWorld() == null) {
            CoreLogging.finer("PlayerPortalEvent's to world is null!", new Object[0]);
            return;
        }
        if (this.config.isUsingCustomPortalSearch()) {
            event.setSearchRadius(this.config.getCustomPortalSearchRadius());
        }
        if (Objects.equals(event.getFrom().getWorld(), event.getTo().getWorld())) {
            CoreLogging.finer("Player '" + event.getPlayer().getName() + "' is portaling to the same world.", new Object[0]);
            return;
        }
        MultiverseWorld fromWorld = (MultiverseWorld)this.getWorldManager().getLoadedWorld(event.getFrom().getWorld()).getOrNull();
        LoadedMultiverseWorld toWorld = (LoadedMultiverseWorld)this.getWorldManager().getLoadedWorld(event.getTo().getWorld()).getOrNull();
        if (toWorld == null) {
            CoreLogging.fine("Player '" + event.getPlayer().getName() + "' is portaling to world '" + event.getTo().getWorld().getName() + "' which is not managed by Multiverse-Core.  No further actions will be taken by Multiverse-Core.", new Object[0]);
            return;
        }
        ResultChain entryResult = this.worldEntryCheckerProvider.forSender((CommandSender)event.getPlayer()).canEnterWorld(fromWorld, toWorld).onFailure(results -> {
            event.setCancelled(true);
            this.getCommandManager().getCommandIssuer(event.getPlayer()).sendError(results.getLastResultMessage());
        });
        CoreLogging.fine("Teleport result: %s", entryResult);
    }

    private void handleGameModeAndFlight(Player player, World world) {
        this.server.getScheduler().runTaskLater(this.plugin, () -> {
            if (!player.isOnline() || !player.getWorld().equals((Object)world)) {
                return;
            }
            CoreLogging.finer("Handling gamemode and flight for player %s in world '%s'", player.getName(), world.getName());
            this.enforcementHandler.handleFlightEnforcement(player);
            this.enforcementHandler.handleGameModeEnforcement(player);
        }, 1L);
    }
}

