/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.display.parsers;

import java.util.Collection;
import java.util.Map;
import org.bukkit.ChatColor;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.display.parsers.ContentProvider;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class MapContentProvider<K, V>
implements ContentProvider {
    private final Map<K, V> map;
    private String format = "%s%s%s%s%s";
    private ChatColor keyColor = ChatColor.WHITE;
    private ChatColor valueColor = ChatColor.WHITE;
    private String separator = ": ";

    public static <K, V> MapContentProvider<K, V> forContent(Map<K, V> map) {
        return new MapContentProvider<K, V>(map);
    }

    MapContentProvider(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public Collection<String> parse(@NotNull MVCommandIssuer issuer) {
        return this.map.entrySet().stream().map(e -> String.format(this.format, this.keyColor, this.formatValue(issuer, e.getKey()), this.separator, this.valueColor, this.formatValue(issuer, e.getValue()))).toList();
    }

    private String formatValue(MVCommandIssuer issuer, Object value) {
        String stringValue;
        if (value instanceof Message) {
            Message message = (Message)value;
            stringValue = message.formatted(issuer);
        } else {
            String string;
            stringValue = value instanceof String ? ((string = (String)value).isEmpty() ? Message.of((MessageKeyProvider)MVCorei18n.CONTENTDISPLAY_EMPTY, new MessageReplacement[0]).formatted(issuer) : string) : (value == null ? null : String.valueOf(value));
        }
        return stringValue == null ? Message.of((MessageKeyProvider)MVCorei18n.CONTENTDISPLAY_NULL, new MessageReplacement[0]).formatted(issuer) : stringValue;
    }

    public MapContentProvider<K, V> withFormat(String format) {
        this.format = format;
        return this;
    }

    public MapContentProvider<K, V> withKeyColor(ChatColor keyColor) {
        this.keyColor = keyColor;
        return this;
    }

    public MapContentProvider<K, V> withValueColor(ChatColor valueColor) {
        this.valueColor = valueColor;
        return this;
    }

    public MapContentProvider<K, V> withSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    public String getFormat() {
        return this.format;
    }

    public ChatColor getKeyColor() {
        return this.keyColor;
    }

    public ChatColor getValueColor() {
        return this.valueColor;
    }

    public String getSeparator() {
        return this.separator;
    }
}

