/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.core.WorldDestination;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Option;

public final class WorldDestinationInstance
extends DestinationInstance<WorldDestinationInstance, WorldDestination> {
    private final MultiverseWorld world;
    private final String direction;
    private final float yaw;

    WorldDestinationInstance(@NotNull WorldDestination destination, @NotNull MultiverseWorld world, @Nullable String direction, float yaw) {
        super(destination);
        this.world = world;
        this.direction = direction;
        this.yaw = yaw;
    }

    @Override
    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        if (!this.world.isLoaded()) {
            return Option.none();
        }
        Location worldLoc = this.world.getSpawnLocation();
        if (!worldLoc.isWorldLoaded()) {
            return Option.none();
        }
        if (this.yaw >= 0.0f) {
            worldLoc.setYaw(this.yaw);
        }
        return Option.of(worldLoc);
    }

    @Override
    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        return Option.none();
    }

    @Override
    public boolean checkTeleportSafety() {
        return true;
    }

    @Override
    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.of(this.world.getName());
    }

    @Override
    @NotNull
    public String serialise() {
        if (this.direction != null) {
            return this.world.getName() + ":" + this.direction;
        }
        return this.world.getName();
    }
}

