/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.matcher;

import java.util.List;
import java.util.stream.Collectors;
import org.mvplugins.multiverse.core.utils.matcher.ExactStringMatcher;
import org.mvplugins.multiverse.core.utils.matcher.RegexStringMatcher;
import org.mvplugins.multiverse.core.utils.matcher.WildcardStringMatcher;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

@ApiStatus.AvailableSince(value="5.2")
public interface StringMatcher {
    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public static StringMatcher fromString(@NotNull String matcherString) {
        if (matcherString.startsWith("r=")) {
            return new RegexStringMatcher(matcherString);
        }
        if (matcherString.contains("*")) {
            return new WildcardStringMatcher(matcherString);
        }
        return new ExactStringMatcher(matcherString);
    }

    @ApiStatus.AvailableSince(value="5.2")
    public boolean matches(@Nullable String var1);

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    default public List<String> filter(@NotNull List<String> values) {
        return values.stream().filter(this::matches).collect(Collectors.toList());
    }
}

