/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.ReflectHelper;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public final class WorldTickDeferrer {
    private final MultiverseCore plugin;
    private Object console = null;
    private Field isIteratingOverLevelsMethod = null;

    @Inject
    WorldTickDeferrer(@NotNull MultiverseCore plugin, @NotNull Server server) {
        this.plugin = plugin;
        Method getServerMethod = ReflectHelper.getMethod(server.getClass(), "getServer", new Class[0]);
        if (getServerMethod == null) {
            CoreLogging.fine("Unable to find getServer method.", new Object[0]);
            return;
        }
        this.console = ReflectHelper.invokeMethod(server, getServerMethod, new Object[0]);
        if (this.console == null) {
            CoreLogging.fine("Unable to find console.", new Object[0]);
            return;
        }
        this.isIteratingOverLevelsMethod = (Field)Try.of(() -> this.console.getClass().getField("isIteratingOverLevels")).getOrNull();
        if (this.isIteratingOverLevelsMethod == null) {
            CoreLogging.fine("Unable to find isIteratingOverLevels field.", new Object[0]);
        }
    }

    public void deferWorldTick(final Runnable action) {
        if (!this.isIteratingOverLevels()) {
            action.run();
            return;
        }
        CoreLogging.fine("Deferring world tick...", new Object[0]);
        new BukkitRunnable(){

            public void run() {
                action.run();
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private boolean isIteratingOverLevels() {
        if (this.console == null || this.isIteratingOverLevelsMethod == null) {
            return false;
        }
        return Objects.requireNonNullElse(ReflectHelper.getFieldValue(this.console, this.isIteratingOverLevelsMethod, Boolean.class), false);
    }
}

