/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.locale.message;

import org.mvplugins.multiverse.core.locale.message.LocalizableMessage;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.external.jetbrains.annotations.Contract;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Either;

public final class MessageReplacement {
    @NotNull
    private final String key;
    @NotNull
    private final Either<String, Message> replacement;

    @Contract(value="_ -> new", pure=true)
    public static Key replace(@NotNull String key) {
        return new Key(key);
    }

    private MessageReplacement(@NotNull String key, @NotNull Message replacement) {
        this.key = key;
        this.replacement = Either.right(replacement);
    }

    private MessageReplacement(@NotNull String key, @Nullable Object replacement) {
        Either<String, Object> either;
        this.key = key;
        if (replacement instanceof Message) {
            Message message = (Message)replacement;
            either = Either.right(message);
        } else {
            either = Either.left(String.valueOf(replacement));
        }
        this.replacement = either;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public Either<String, Message> getReplacement() {
        return this.replacement;
    }

    public static final class Key {
        @NotNull
        private final String key2;

        private Key(@NotNull String key) {
            this.key2 = key;
        }

        @Contract(value="_ -> new", pure=true)
        public MessageReplacement with(@NotNull Message replacement) {
            return new MessageReplacement(this.key2, replacement);
        }

        @Contract(value="_ -> new", pure=true)
        public MessageReplacement with(@Nullable Object replacement) {
            LocalizableMessage localizableMessage;
            if (replacement instanceof LocalizableMessage && (localizableMessage = (LocalizableMessage)replacement).getLocalizableMessage() != null) {
                return new MessageReplacement(this.key2, localizableMessage.getLocalizableMessage());
            }
            if (replacement instanceof Throwable) {
                Throwable throwable = (Throwable)replacement;
                return new MessageReplacement(this.key2, throwable.getLocalizedMessage());
            }
            return new MessageReplacement(this.key2, replacement);
        }
    }

    public static enum Replace {
        COUNT(MessageReplacement.replace("{count}")),
        DESTINATION(MessageReplacement.replace("{destination}")),
        ERROR(MessageReplacement.replace("{error}")),
        GAMERULE(MessageReplacement.replace("{gamerule}")),
        LOCATION(MessageReplacement.replace("{location}")),
        NAME(MessageReplacement.replace("{name}")),
        PLAYER(MessageReplacement.replace("{player}")),
        REASON(MessageReplacement.replace("{reason}")),
        VALUE(MessageReplacement.replace("{value}")),
        WORLD(MessageReplacement.replace("{world}"));

        private final Key replaceKey;

        private Replace(Key replaceKey) {
            this.replaceKey = replaceKey;
        }

        @Contract(value="_ -> new", pure=true)
        public MessageReplacement with(@NotNull Message replacement) {
            return this.replaceKey.with(replacement);
        }

        @Contract(value="_ -> new", pure=true)
        public MessageReplacement with(@Nullable Object replacement) {
            return this.replaceKey.with(replacement);
        }
    }
}

