/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.locale;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.bukkit.plugin.Plugin;

final class FileResClassLoader
extends ClassLoader {
    private final transient File targetFolder;

    FileResClassLoader(Plugin plugin, String subFolder) {
        super(plugin.getClass().getClassLoader());
        this.targetFolder = new File(plugin.getDataFolder(), subFolder);
    }

    @Override
    public URL getResource(String string) {
        File file = new File(this.targetFolder, string);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        File file = new File(this.targetFolder, string);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

