/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.listeners;

import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.dynamiclistener.EventRunnable;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventClass;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.IgnoreIfCancelled;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.SkipIfEventExist;
import org.mvplugins.multiverse.core.listeners.CoreListener;
import org.mvplugins.multiverse.core.listeners.MVPlayerListener;
import org.mvplugins.multiverse.core.utils.text.ChatTextFormatter;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class MVChatListener
implements CoreListener {
    private final CoreConfig config;
    private final WorldManager worldManager;
    private final MVPlayerListener playerListener;

    @Inject
    MVChatListener(CoreConfig config, WorldManager worldManager, MVPlayerListener playerListener) {
        this.config = config;
        this.worldManager = worldManager;
        this.playerListener = playerListener;
    }

    @EventClass(value="io.papermc.paper.event.player.AsyncChatEvent")
    @IgnoreIfCancelled
    EventRunnable asyncChat() {
        return new EventRunnable<AsyncChatEvent>(){

            @Override
            public void onEvent(AsyncChatEvent event) {
                if (!MVChatListener.this.config.isEnablePrefixChat()) {
                    return;
                }
                ChatRenderer currentRenderer = event.renderer();
                ChatRenderer chatRenderer = this.getPrefixedChatRenderer(currentRenderer);
                event.renderer(chatRenderer);
            }

            private ChatRenderer getPrefixedChatRenderer(ChatRenderer currentRenderer) {
                return (source, sourceDisplayName, message, viewer) -> LegacyComponentSerializer.legacyAmpersand().deserialize(MVChatListener.this.config.getPrefixChatFormat()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%world%").replacement((ComponentLike)LegacyComponentSerializer.legacyAmpersand().deserialize(MVChatListener.this.getWorldName(source))).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chat%").replacement((ComponentLike)currentRenderer.render(source, sourceDisplayName, message, viewer)).build());
            }
        };
    }

    @EventMethod
    @SkipIfEventExist(value="io.papermc.paper.event.player.AsyncChatEvent")
    @IgnoreIfCancelled
    void asyncPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.config.isEnablePrefixChat()) {
            return;
        }
        String worldName = this.getWorldName(event.getPlayer());
        String chat = event.getFormat();
        String prefixChatFormat = this.config.getPrefixChatFormat();
        prefixChatFormat = prefixChatFormat.replace("%world%", worldName).replace("%chat%", chat);
        if ((prefixChatFormat = ChatTextFormatter.colorize(prefixChatFormat)) != null) {
            event.setFormat(prefixChatFormat);
        }
    }

    private String getWorldName(Player player) {
        String world = this.playerListener.getPlayerWorld().get(player.getName());
        if (world == null) {
            world = player.getWorld().getName();
            this.playerListener.getPlayerWorld().put(player.getName(), world);
        }
        return this.worldManager.getLoadedWorld(world).map(mvworld -> mvworld.isHidden() ? "" : mvworld.getAliasOrName()).getOrElse("");
    }
}

