/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.display.parsers;

import java.util.Collection;
import java.util.List;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.display.parsers.ContentProvider;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class ListContentProvider<T>
implements ContentProvider {
    private final List<T> list;

    public static <T> ListContentProvider<T> forContent(List<T> list) {
        return new ListContentProvider<T>(list);
    }

    ListContentProvider(List<T> list) {
        this.list = list;
    }

    @Override
    public Collection<String> parse(@NotNull MVCommandIssuer issuer) {
        return this.list.stream().map(object -> {
            String string;
            if (object instanceof Message) {
                Message message = (Message)object;
                string = message.formatted(issuer);
            } else {
                string = String.valueOf(object);
            }
            return string;
        }).toList();
    }

    public List<T> getList() {
        return this.list;
    }
}

