/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.display.handlers;

import java.util.List;
import java.util.stream.Collectors;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.display.filters.ContentFilter;
import org.mvplugins.multiverse.core.display.filters.DefaultContentFilter;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public abstract class BaseSendHandler<T extends BaseSendHandler<?>>
implements SendHandler {
    protected Message header = null;
    protected ContentFilter filter = DefaultContentFilter.get();
    protected Message noContentMessage = Message.of((MessageKeyProvider)MVCorei18n.CONTENTDISPLAY_NOCONTENT, new MessageReplacement[0]);

    @Override
    public void send(@NotNull MVCommandIssuer issuer, @NotNull List<String> content) {
        this.sendHeader(issuer);
        List<String> filteredContent = this.filterContent(content);
        if (filteredContent.isEmpty() && this.noContentMessage != null) {
            issuer.sendMessage(this.noContentMessage);
            return;
        }
        this.sendContent(issuer, filteredContent);
    }

    protected void sendHeader(MVCommandIssuer issuer) {
        if (this.header != null) {
            issuer.sendMessage(this.header);
        }
    }

    protected List<String> filterContent(@NotNull List<String> content) {
        if (this.filter.needToFilter()) {
            return content.stream().filter(this.filter::checkMatch).collect(Collectors.toList());
        }
        return content;
    }

    protected abstract void sendContent(@NotNull MVCommandIssuer var1, @NotNull List<String> var2);

    public T withHeader(@NotNull String header, Object ... replacements) {
        return this.withHeader(Message.of(String.format(header, replacements), new MessageReplacement[0]));
    }

    public T withHeader(@NotNull Message header) {
        this.header = header;
        return this.getT();
    }

    public T withFilter(@NotNull ContentFilter filter) {
        this.filter = filter;
        return this.getT();
    }

    public T noContentMessage(@Nullable String message) {
        return this.noContentMessage(message == null ? null : Message.of(message, new MessageReplacement[0]));
    }

    public T noContentMessage(@Nullable Message message) {
        this.noContentMessage = message;
        return this.getT();
    }

    @NotNull
    private T getT() {
        return (T)this;
    }

    public Message getHeader() {
        return this.header;
    }

    public ContentFilter getFilter() {
        return this.filter;
    }

    public Message getNoContentMessage() {
        return this.noContentMessage;
    }
}

