/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.core.BedDestination;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Option;

public final class BedDestinationInstance
extends DestinationInstance<BedDestinationInstance, BedDestination> {
    private final Player player;

    BedDestinationInstance(@NotNull BedDestination destination, @Nullable Player player) {
        super(destination);
        this.player = player;
    }

    @Override
    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        if (this.player != null) {
            return Option.of(this.player.getBedSpawnLocation());
        }
        if (teleportee instanceof Player) {
            return Option.of(((Player)teleportee).getBedSpawnLocation());
        }
        return Option.none();
    }

    @Override
    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        return Option.none();
    }

    @Override
    public boolean checkTeleportSafety() {
        return false;
    }

    @Override
    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.of(this.player != null ? this.player.getName() : "playerbed");
    }

    @Override
    @NotNull
    public String serialise() {
        return this.player != null ? this.player.getName() : "playerbed";
    }
}

