/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.migration;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.mvplugins.multiverse.core.config.migration.action.MigratorAction;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class VersionMigrator
implements Comparable<VersionMigrator> {
    private final double version;
    private final List<MigratorAction> actions;

    public static Builder builder(double version) {
        return new Builder(version);
    }

    protected VersionMigrator(double version, List<MigratorAction> actions) {
        this.version = version;
        this.actions = actions;
    }

    public void migrate(ConfigurationSection config) {
        this.actions.forEach(action -> action.migrate(config));
    }

    public double getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(@NotNull VersionMigrator o) {
        return Double.compare(this.version, o.version);
    }

    public static class Builder {
        private final double version;
        private final List<MigratorAction> actions = new ArrayList<MigratorAction>();

        public Builder(double version) {
            this.version = version;
        }

        public Builder addAction(MigratorAction action) {
            this.actions.add(action);
            return this;
        }

        public VersionMigrator build() {
            return new VersionMigrator(this.version, this.actions);
        }
    }
}

