/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.handle;

import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.mvplugins.multiverse.core.config.handle.FileConfigurationHandle;
import org.mvplugins.multiverse.core.config.migration.ConfigMigrator;
import org.mvplugins.multiverse.core.config.node.CommentedNode;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.core.config.node.ValueNode;
import org.mvplugins.multiverse.external.commentedconfiguration.CommentedConfiguration;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;

public class CommentedConfigurationHandle
extends FileConfigurationHandle<CommentedConfiguration> {
    @NotNull
    public static Builder builder(@NotNull Path configPath, @NotNull NodeGroup nodes) {
        return new Builder(configPath, nodes);
    }

    protected CommentedConfigurationHandle(@NotNull Path configPath, @Nullable Logger logger, @NotNull NodeGroup nodes, @Nullable ConfigMigrator migrator) {
        super(configPath, logger, nodes, migrator);
    }

    @Override
    protected void loadConfigObject() throws IOException {
        this.config = new CommentedConfiguration(this.configPath, this.logger);
        if (!((CommentedConfiguration)this.config).load()) {
            throw new IOException("Failed to load commented config file " + String.valueOf(this.configPath) + ". See console for details.");
        }
    }

    @Override
    public Try<Void> save() {
        return Try.run(() -> {
            this.config = new CommentedConfiguration(this.configPath, this.logger);
            this.nodes.forEach(node -> {
                CommentedNode typedNode;
                if (node instanceof CommentedNode && (typedNode = (CommentedNode)node).getComments().length > 0) {
                    ((CommentedConfiguration)this.config).addComment(typedNode.getPath(), typedNode.getComments());
                }
                if (node instanceof ValueNode) {
                    ValueNode valueNode = (ValueNode)node;
                    this.serializeNodeToConfig(valueNode);
                }
            });
            ((CommentedConfiguration)this.config).save();
        });
    }

    public static class Builder
    extends FileConfigurationHandle.Builder<CommentedConfiguration, Builder> {
        protected Builder(@NotNull Path configPath, @NotNull NodeGroup nodes) {
            super(configPath, nodes);
        }

        @Override
        @NotNull
        public CommentedConfigurationHandle build() {
            return new CommentedConfigurationHandle(this.configPath, this.logger, this.nodes, this.migrator);
        }
    }
}

