/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.MessageType;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class VersionCommand
extends CoreCommand {
    private final MultiverseCore plugin;

    @Inject
    VersionCommand(MultiverseCore plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="version")
    @CommandPermission(value="multiverse.core.version")
    @Description(value="{@@mv-core.version.description}")
    void versionCommand(BukkitCommandIssuer issuer) {
        issuer.sendMessage(MessageType.INFO, MVCorei18n.VERSION_MV, "{version}", this.plugin.getDescription().getVersion());
        issuer.sendMessage(MessageType.INFO, MVCorei18n.VERSION_AUTHORS, "{authors}", String.join((CharSequence)", ", this.plugin.getDescription().getAuthors()));
        issuer.sendMessage(MessageType.INFO, MVCorei18n.VERSION_SECRETCODE, new String[0]);
    }

    @Service
    private static final class LegacyAlias
    extends VersionCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(MultiverseCore plugin) {
            super(plugin);
        }

        @Override
        @CommandAlias(value="mvversion")
        void versionCommand(BukkitCommandIssuer issuer) {
            super.versionCommand(issuer);
        }
    }
}

