/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command.flag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagGroup;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsParser;
import org.mvplugins.multiverse.core.command.flag.CommandValueFlag;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public class CommandFlagsManager {
    private final Map<String, CommandFlagGroup> flagGroupMap = new HashMap<String, CommandFlagGroup>();

    public void registerFlagGroup(@NotNull CommandFlagGroup flagGroup) {
        this.flagGroupMap.put(flagGroup.getName(), flagGroup);
    }

    @Nullable
    public CommandFlagGroup getFlagGroup(@Nullable String groupName) {
        return this.flagGroupMap.get(groupName);
    }

    @NotNull
    public Collection<String> suggest(@Nullable String groupName, @NotNull String[] flags) {
        CommandFlag currentFlag;
        CommandFlagGroup flagGroup = this.getFlagGroup(groupName);
        if (flagGroup == null) {
            CoreLogging.warning("Unknown flag group: " + groupName, new Object[0]);
            return Collections.emptyList();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        CommandFlag commandFlag = currentFlag = flags.length <= 1 ? null : flagGroup.getFlagByKey(flags[flags.length - 2]);
        if (currentFlag instanceof CommandValueFlag) {
            CommandValueFlag valueFlag = (CommandValueFlag)currentFlag;
            if (valueFlag.getCompletion() != null) {
                suggestions.addAll(valueFlag.getCompletion().apply(flags[flags.length - 1]));
            }
            if (valueFlag.isOptional()) {
                suggestions.addAll(flagGroup.getRemainingKeys(flags));
            }
        } else {
            suggestions.addAll(flagGroup.getRemainingKeys(flags));
        }
        return suggestions;
    }

    @NotNull
    public ParsedCommandFlags parse(@Nullable String groupName, @NotNull String[] flags) {
        CommandFlagGroup flagGroup = this.getFlagGroup(groupName);
        if (flagGroup == null) {
            return ParsedCommandFlags.EMPTY;
        }
        return new CommandFlagsParser(this.getFlagGroup(groupName), flags).parse();
    }
}

