/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command;

import com.google.common.base.Strings;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.anchor.AnchorManager;
import org.mvplugins.multiverse.core.anchor.MultiverseAnchor;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.command.context.GameRuleValue;
import org.mvplugins.multiverse.core.command.context.PlayerLocation;
import org.mvplugins.multiverse.core.command.context.issueraware.IssuerAwareContextBuilder;
import org.mvplugins.multiverse.core.command.context.issueraware.MultiverseWorldValue;
import org.mvplugins.multiverse.core.command.context.issueraware.PlayerArrayValue;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.display.filters.ContentFilter;
import org.mvplugins.multiverse.core.display.filters.DefaultContentFilter;
import org.mvplugins.multiverse.core.display.filters.RegexContentFilter;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.PlayerFinder;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.generators.GeneratorPlugin;
import org.mvplugins.multiverse.core.world.generators.GeneratorProvider;
import org.mvplugins.multiverse.external.acf.commands.ACFUtil;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandExecutionContext;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.CommandExecutionContext;
import org.mvplugins.multiverse.external.acf.commands.CommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.InvalidCommandArgument;
import org.mvplugins.multiverse.external.acf.commands.MinecraftMessageKeys;
import org.mvplugins.multiverse.external.acf.commands.PaperCommandContexts;
import org.mvplugins.multiverse.external.acf.commands.contexts.ContextResolver;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public class MVCommandContexts
extends PaperCommandContexts {
    private final MVCommandManager mvCommandManager;
    private final DestinationsProvider destinationsProvider;
    private final WorldManager worldManager;
    private final CoreConfig config;
    private final AnchorManager anchorManager;
    private final GeneratorProvider generatorProvider;

    @Inject
    MVCommandContexts(MVCommandManager mvCommandManager, DestinationsProvider destinationsProvider, WorldManager worldManager, CoreConfig config, AnchorManager anchorManager, GeneratorProvider generatorProvider) {
        super(mvCommandManager);
        this.mvCommandManager = mvCommandManager;
        this.destinationsProvider = destinationsProvider;
        this.worldManager = worldManager;
        this.config = config;
        this.anchorManager = anchorManager;
        this.generatorProvider = generatorProvider;
        this.registerIssuerOnlyContext(BukkitCommandIssuer.class, CommandExecutionContext::getIssuer);
        this.registerIssuerOnlyContext(MVCommandIssuer.class, this::parseMVCommandIssuer);
        this.registerOptionalContext(ContentFilter.class, this::parseContentFilter);
        this.registerContext(DestinationInstance.class, this::parseDestination);
        this.registerContext(GameRule.class, this::parseGameRule);
        this.registerContext(GameRuleValue.class, this::parseGameRuleValue);
        this.registerContext(GeneratorPlugin.class, this::parseGeneratorPlugin);
        this.registerIssuerAwareContext(LoadedMultiverseWorld.class, this.loadedMultiverseWorldContextBuilder().generateContext());
        this.registerIssuerAwareContext(LoadedMultiverseWorld[].class, this.loadedMultiverseWorldArrayContextBuilder().generateContext());
        this.registerIssuerAwareContext(MultiverseWorld.class, this.multiverseWorldContextBuilder().generateContext());
        this.registerIssuerAwareContext(MultiverseWorldValue.class, this.multiverseWorldContextBuilder().generateContext(MultiverseWorldValue::new));
        this.registerIssuerAwareContext(MultiverseWorld[].class, this.multiverseWorldArrayContextBuilder().generateContext());
        this.registerContext(MultiverseAnchor.class, this::parseMultiverseAnchor);
        this.registerIssuerAwareContext(Player.class, this.playerContextBuilder().generateContext());
        this.registerIssuerAwareContext(Player[].class, this.playerArrayContextBuilder().generateContext());
        this.registerIssuerAwareContext(PlayerArrayValue.class, this.playerArrayContextBuilder().generateContext(PlayerArrayValue::new));
        this.registerIssuerAwareContext(PlayerLocation.class, this::parsePlayerLocation);
        this.registerContext(SpawnCategory[].class, this::parseSpawnCategories);
    }

    private MVCommandIssuer parseMVCommandIssuer(BukkitCommandExecutionContext context) {
        if (context.getIssuer() instanceof MVCommandIssuer) {
            return (MVCommandIssuer)context.getIssuer();
        }
        return this.mvCommandManager.getCommandIssuer(context.getSender());
    }

    private ContentFilter parseContentFilter(BukkitCommandExecutionContext context) {
        if (Strings.isNullOrEmpty((String)context.getFirstArg())) {
            return DefaultContentFilter.get();
        }
        String filterString = context.popFirstArg();
        return RegexContentFilter.fromString(filterString);
    }

    private DestinationInstance<?, ?> parseDestination(BukkitCommandExecutionContext context) {
        String destination = context.popFirstArg();
        if (Strings.isNullOrEmpty((String)destination)) {
            throw new InvalidCommandArgument("No destination specified.");
        }
        return this.destinationsProvider.parseDestination(context.getSender(), destination).getOrThrow(failure -> new InvalidCommandArgument(failure.getFailureMessage().formatted((CommandIssuer)context.getIssuer())));
    }

    private GameRule<?> parseGameRule(BukkitCommandExecutionContext context) {
        String gameRuleName = context.popFirstArg();
        if (Strings.isNullOrEmpty((String)gameRuleName)) {
            throw new InvalidCommandArgument("No game rule specified.");
        }
        GameRule gameRule = GameRule.getByName((String)gameRuleName);
        if (gameRule == null) {
            throw new InvalidCommandArgument("The game rule " + gameRuleName + " is not valid.");
        }
        return gameRule;
    }

    private GameRuleValue parseGameRuleValue(BukkitCommandExecutionContext context) {
        GameRule gameRule = (GameRule)context.getResolvedArg(GameRule.class);
        if (gameRule == null) {
            throw new InvalidCommandArgument("No game rule specified.");
        }
        String valueString = context.getFirstArg();
        if (Strings.isNullOrEmpty((String)valueString)) {
            throw new InvalidCommandArgument("No game rule value specified.");
        }
        ContextResolver resolver = this.getResolver(gameRule.getType());
        if (resolver == null) {
            return new GameRuleValue(valueString);
        }
        Object resolvedValue = resolver.getContext(context);
        if (resolvedValue == null) {
            throw new InvalidCommandArgument("The game rule value " + valueString + " is not valid for game rule " + gameRule.getName() + ".");
        }
        return new GameRuleValue(resolvedValue);
    }

    private GeneratorPlugin parseGeneratorPlugin(BukkitCommandExecutionContext context) {
        GeneratorPlugin generatorPlugin = this.generatorProvider.getGeneratorPlugin(context.popFirstArg());
        if (generatorPlugin == null) {
            throw new InvalidCommandArgument("Invalid generator plugin: " + context.getFirstArg());
        }
        return generatorPlugin;
    }

    private IssuerAwareContextBuilder<LoadedMultiverseWorld> loadedMultiverseWorldContextBuilder() {
        return new IssuerAwareContextBuilder<LoadedMultiverseWorld>().fromPlayer((context, player) -> (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(player.getWorld()).getOrNull()).fromInput((context, input) -> this.getLoadedMultiverseWorld((String)input)).issuerOnlyFailMessage(context -> Message.of("This command can only be used by a player in a loaded Multiverse World.", new MessageReplacement[0])).issuerAwarePlayerFailMessage((context, player) -> Message.of("You are not in a loaded multiverse world. Either specify a multiverse world name or use this command in a loaded multiverse world.", new MessageReplacement[0])).issuerAwareInputFailMessage((context, input) -> Message.of("World '" + input + "' is not a loaded multiverse world. Remember to specify the world name when using this command in console.", new MessageReplacement[0])).inputOnlyFailMessage((context, input) -> Message.of("World " + input + " is not a loaded multiverse world.", new MessageReplacement[0]));
    }

    private IssuerAwareContextBuilder<LoadedMultiverseWorld[]> loadedMultiverseWorldArrayContextBuilder() {
        return new IssuerAwareContextBuilder<LoadedMultiverseWorld[]>().fromPlayer((context, player) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).fromInput((context, input) -> {
            String[] worldNames = input == null ? new String[]{} : REPatterns.COMMA.split((CharSequence)input);
            HashSet<LoadedMultiverseWorld> worlds = new HashSet<LoadedMultiverseWorld>(worldNames.length);
            for (String worldName : worldNames) {
                if ("*".equals(worldName)) {
                    worlds.addAll(this.worldManager.getLoadedWorlds());
                    break;
                }
                LoadedMultiverseWorld world = this.getLoadedMultiverseWorld(worldName);
                if (world == null) {
                    throw new InvalidCommandArgument("World " + worldName + " is not a loaded multiverse world.");
                }
                worlds.add(world);
            }
            return worlds.isEmpty() ? null : worlds.toArray(new LoadedMultiverseWorld[0]);
        }).issuerOnlyFailMessage(context -> Message.of("This command can only be used by a player in a loaded Multiverse World.", new MessageReplacement[0])).issuerAwarePlayerFailMessage((context, player) -> Message.of("You are not in a loaded multiverse world. Either specify a multiverse world name or use this command in a loaded multiverse world.", new MessageReplacement[0])).issuerAwareInputFailMessage((context, input) -> Message.of("World '" + input + "' is not a loaded multiverse world. Remember to specify the world name when using this command in console.", new MessageReplacement[0])).inputOnlyFailMessage((context, input) -> Message.of("World " + input + " is not a loaded multiverse world.", new MessageReplacement[0]));
    }

    @Nullable
    private LoadedMultiverseWorld getLoadedMultiverseWorld(String worldName) {
        return this.config.getResolveAliasName() ? (LoadedMultiverseWorld)this.worldManager.getLoadedWorldByNameOrAlias(worldName).getOrNull() : (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(worldName).getOrNull();
    }

    private IssuerAwareContextBuilder<MultiverseWorld> multiverseWorldContextBuilder() {
        return new IssuerAwareContextBuilder<MultiverseWorld>().fromPlayer((context, player) -> (MultiverseWorld)this.worldManager.getWorld(player.getWorld()).getOrNull()).fromInput((context, input) -> this.getMultiverseWorld((String)input)).issuerOnlyFailMessage(context -> Message.of("This command can only be used by a player in a Multiverse World.", new MessageReplacement[0])).issuerAwarePlayerFailMessage((context, player) -> Message.of("You are not in a multiverse world. Either specify a multiverse world name or use this command in a multiverse world.", new MessageReplacement[0])).issuerAwareInputFailMessage((context, input) -> Message.of("World '" + input + "' is not a multiverse world. Remember to specify the world name when using this command in console.", new MessageReplacement[0])).inputOnlyFailMessage((context, input) -> Message.of("World " + input + " is not a multiverse world.", new MessageReplacement[0]));
    }

    private IssuerAwareContextBuilder<MultiverseWorld[]> multiverseWorldArrayContextBuilder() {
        return new IssuerAwareContextBuilder<MultiverseWorld[]>().fromPlayer((context, player) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).fromInput((context, input) -> {
            String[] worldNames = input == null ? new String[]{} : REPatterns.COMMA.split((CharSequence)input);
            HashSet<MultiverseWorld> worlds = new HashSet<MultiverseWorld>(worldNames.length);
            for (String worldName : worldNames) {
                if ("*".equals(worldName)) {
                    worlds.addAll(this.worldManager.getWorlds());
                    break;
                }
                MultiverseWorld world = this.getMultiverseWorld(worldName);
                if (world == null) {
                    throw new InvalidCommandArgument("World " + worldName + " is not a multiverse world.");
                }
                worlds.add(world);
            }
            return worlds.isEmpty() ? null : worlds.toArray(new MultiverseWorld[0]);
        }).issuerOnlyFailMessage(context -> Message.of("This command can only be used by a player in a Multiverse World.", new MessageReplacement[0])).issuerAwarePlayerFailMessage((context, player) -> Message.of("You are not in a multiverse world. Either specify a multiverse world name or use this command in a multiverse world.", new MessageReplacement[0])).issuerAwareInputFailMessage((context, input) -> Message.of("World '" + input + "' is not a multiverse world. Remember to specify the world name when using this command in console.", new MessageReplacement[0])).inputOnlyFailMessage((context, input) -> Message.of("World " + input + " is not a multiverse world.", new MessageReplacement[0]));
    }

    @Nullable
    private MultiverseWorld getMultiverseWorld(String worldName) {
        return this.config.getResolveAliasName() ? (MultiverseWorld)this.worldManager.getWorldByNameOrAlias(worldName).getOrNull() : (MultiverseWorld)this.worldManager.getWorld(worldName).getOrNull();
    }

    private MultiverseAnchor parseMultiverseAnchor(BukkitCommandExecutionContext context) {
        String anchorName = context.popFirstArg();
        return this.anchorManager.getAnchor(anchorName).getOrElseThrow(() -> new InvalidCommandArgument("The anchor '" + anchorName + "' does not exist."));
    }

    private IssuerAwareContextBuilder<Player> playerContextBuilder() {
        return new IssuerAwareContextBuilder<Player>().fromPlayer((context, player) -> player).fromInput((context, input) -> PlayerFinder.get(input, context.getSender())).issuerOnlyFailMessage(context -> Message.of("This command can only be used by a player.", new MessageReplacement[0])).issuerAwareInputFailMessage((context, input) -> Message.of("Invalid player: " + input + ". Either specify an online player or use this command as a player.", new MessageReplacement[0])).inputOnlyFailMessage((context, input) -> Message.of("Player " + input + " not found.", new MessageReplacement[0]));
    }

    private IssuerAwareContextBuilder<Player[]> playerArrayContextBuilder() {
        return new IssuerAwareContextBuilder<Player[]>().fromPlayer((context, player) -> new Player[]{player}).fromInput((context, input) -> {
            Player[] players = PlayerFinder.getMulti(input, context.getSender()).toArray(new Player[0]);
            return players.length == 0 ? null : players;
        }).issuerOnlyFailMessage(context -> Message.of("This command can only be used by a player.", new MessageReplacement[0])).issuerAwareInputFailMessage((context, input) -> Message.of("Invalid player: " + input + ". Either specify an online player or use this command as a player.", new MessageReplacement[0])).inputOnlyFailMessage((context, input) -> Message.of("Player " + input + " not found.", new MessageReplacement[0]));
    }

    private PlayerLocation parsePlayerLocation(BukkitCommandExecutionContext context) {
        Try<Location> location = Try.of(() -> this.parseLocationFromInput(context.getFirstArg(), context.getSender()));
        if (location.isSuccess()) {
            context.popFirstArg();
            return new PlayerLocation(location.get());
        }
        if (context.getPlayer() != null) {
            return new PlayerLocation(context.getPlayer().getLocation());
        }
        if (context.getFirstArg() == null) {
            throw new InvalidCommandArgument("You must specify a world location when using this command in console.");
        }
        if (location.getCause() instanceof InvalidCommandArgument) {
            throw (InvalidCommandArgument)location.getCause();
        }
        throw new RuntimeException(location.getCause());
    }

    private Location parseLocationFromInput(String input, CommandSender sender) {
        String rest;
        String world;
        String[] split = REPatterns.COLON.split(input, 2);
        if (split.length == 0) {
            throw new InvalidCommandArgument(true);
        }
        if (split.length < 2 && !(sender instanceof Player) && !(sender instanceof BlockCommandSender)) {
            throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_PLEASE_SPECIFY_WORLD, new String[0]);
        }
        Location sourceLoc = null;
        if (split.length == 2) {
            world = split[0];
            rest = split[1];
        } else if (sender instanceof Player) {
            sourceLoc = ((Player)sender).getLocation();
            world = sourceLoc.getWorld().getName();
            rest = split[0];
        } else {
            if (!(sender instanceof BlockCommandSender)) {
                throw new InvalidCommandArgument(true);
            }
            sourceLoc = ((BlockCommandSender)sender).getBlock().getLocation();
            world = sourceLoc.getWorld().getName();
            rest = split[0];
        }
        boolean rel = rest.startsWith("~");
        split = REPatterns.COMMA.split(rel ? rest.substring(1) : rest);
        if (split.length < 3) {
            throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_PLEASE_SPECIFY_XYZ, new String[0]);
        }
        Double x = ACFUtil.parseDouble(split[0], rel ? Double.valueOf(0.0) : null);
        Double y = ACFUtil.parseDouble(split[1], rel ? Double.valueOf(0.0) : null);
        Double z = ACFUtil.parseDouble(split[2], rel ? Double.valueOf(0.0) : null);
        if (sourceLoc != null && rel) {
            x = x + sourceLoc.getX();
            y = y + sourceLoc.getY();
            z = z + sourceLoc.getZ();
        } else if (rel) {
            throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_CONSOLE_NOT_RELATIVE, new String[0]);
        }
        if (x != null && y != null && z != null) {
            World worldObj = Bukkit.getWorld((String)world);
            if (worldObj == null) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.INVALID_WORLD, new String[0]);
            }
            if (split.length >= 5) {
                Float yaw = ACFUtil.parseFloat(split[3]);
                Float pitch = ACFUtil.parseFloat(split[4]);
                if (pitch != null && yaw != null) {
                    return new Location(worldObj, x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
                }
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_PLEASE_SPECIFY_XYZ, new String[0]);
            }
            return new Location(worldObj, x.doubleValue(), y.doubleValue(), z.doubleValue());
        }
        throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_PLEASE_SPECIFY_XYZ, new String[0]);
    }

    private SpawnCategory[] parseSpawnCategories(BukkitCommandExecutionContext context) {
        String[] split;
        if (context.isOptional() && context.getArgs().isEmpty()) {
            return new SpawnCategory[0];
        }
        HashSet<SpawnCategory> categories = new HashSet<SpawnCategory>();
        for (String category : split = REPatterns.COMMA.split(context.popFirstArg())) {
            SpawnCategory spawnCategory = (SpawnCategory)ACFUtil.simpleMatch(SpawnCategory.class, category);
            if (spawnCategory == null) continue;
            categories.add(spawnCategory);
        }
        return categories.toArray(new SpawnCategory[0]);
    }
}

